/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scheme.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scheme.bean.SchemeApprovalChangeEntity;
import com.ejianc.business.scheme.bean.SchemeApprovalEntity;
import com.ejianc.business.scheme.enums.ChangeStatusEnum;
import com.ejianc.business.scheme.mapper.SchemeApprovalChangeMapper;
import com.ejianc.business.scheme.service.ISchemeApprovalChangeService;
import com.ejianc.business.scheme.service.ISchemeApprovalService;
import com.ejianc.business.scheme.vo.SchemeApprovalChangeVO;
import com.ejianc.business.scheme.vo.SchemeApprovalVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="schemeApprovalChangeService")
public class SchemeApprovalChangeServiceImpl
extends BaseServiceImpl<SchemeApprovalChangeMapper, SchemeApprovalChangeEntity>
implements ISchemeApprovalChangeService {
    private static final String BILL_CODE_ROLE = "SCHEME_APPROVAL_CHANGE_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISchemeApprovalService approvalService;

    @Override
    public CommonResponse<SchemeApprovalChangeVO> saveOrUpdate(SchemeApprovalChangeVO saveorUpdateVO) {
        SchemeApprovalChangeEntity entity = (SchemeApprovalChangeEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SchemeApprovalChangeEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
            entity.setChangeVersion(1);
        } else {
            entity.setChangeVersion(entity.getChangeVersion() + 1);
        }
        if (2 == entity.getChangeStatus()) {
            throw new BusinessException("\u5408\u540c\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        super.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(SchemeApprovalEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(SchemeApprovalEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(SchemeApprovalEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getSourceId());
        this.approvalService.update((Wrapper)updateWrapper);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), SchemeApprovalChangeVO.class));
    }

    @Override
    public void deleteChange(List<SchemeApprovalChangeVO> vos) {
        for (SchemeApprovalChangeVO vo : vos) {
            SchemeApprovalChangeEntity changeEntity = (SchemeApprovalChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            if (changeEntity.getChangeVersion() == 1) {
                updateWrapper.set(SchemeApprovalEntity::getChangeStatus, (Object)ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            } else {
                updateWrapper.set(SchemeApprovalEntity::getChangeStatus, (Object)ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
            }
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getSourceId());
            this.approvalService.update((Wrapper)updateWrapper);
            super.removeById((Serializable)vo, false);
        }
    }

    @Override
    public SchemeApprovalVO queryDetailChange(Long id) {
        SchemeApprovalEntity entity = (SchemeApprovalEntity)((Object)this.approvalService.selectById(id));
        if (entity != null) {
            SchemeApprovalVO vo = (SchemeApprovalVO)BeanMapper.map((Object)((Object)entity), SchemeApprovalVO.class);
            vo.setBillState(null);
            vo.setCreateUserCode(null);
            vo.setCreateTime(null);
            vo.setUpdateUserCode(null);
            vo.setUpdateTime(null);
            return vo;
        }
        return null;
    }

    @Override
    public List<SchemeApprovalChangeVO> queryChangeHistory(Long id) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SchemeApprovalChangeEntity::getSourceId, (Object)id);
        lambda.in(SchemeApprovalChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(SchemeApprovalChangeEntity::getUsedTime);
        List list = ((SchemeApprovalChangeMapper)this.baseMapper).selectList((Wrapper)lambda);
        if (null != list && list.size() > 0) {
            List voList = BeanMapper.mapList((Iterable)list, SchemeApprovalChangeVO.class);
            for (SchemeApprovalChangeVO vo : voList) {
                String historyBillCode = vo.getBillCode() + "-" + vo.getChangeVersion();
                vo.setHistoryBillCode(historyBillCode);
            }
            return voList;
        }
        return null;
    }
}

