package com.ejianc.business.scheme.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scheme.bean.SchemeApprovalChangeEntity;
import com.ejianc.business.scheme.service.ISchemeApprovalChangeService;
import com.ejianc.business.scheme.vo.SchemeApprovalChangeVO;
import com.ejianc.business.scheme.vo.SchemeApprovalVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 施工方案报批变更实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("schemeApprovalChange")
public class SchemeApprovalChangeController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ISchemeApprovalChangeService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SchemeApprovalChangeVO> saveOrUpdate(@RequestBody SchemeApprovalChangeVO saveorUpdateVO) {
        CommonResponse<SchemeApprovalChangeVO> response = service.saveOrUpdate(saveorUpdateVO);
        return response;
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemeApprovalChangeVO> queryDetail(Long id) {
    	SchemeApprovalChangeEntity entity = service.selectById(id);
    	SchemeApprovalChangeVO vo = BeanMapper.map(entity, SchemeApprovalChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SchemeApprovalChangeVO> vos) {
        service.deleteChange(vos);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SchemeApprovalChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<SchemeApprovalChangeEntity> page = service.queryPage(param,false);
        IPage<SchemeApprovalChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SchemeApprovalChangeVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 变更新增
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailChange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemeApprovalVO> queryDetailChange(@RequestParam Long id) {
        SchemeApprovalVO vo = service.queryDetailChange(id);
        return CommonResponse.success(vo);
    }

    /**
     * 合同变更历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryChangeHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SchemeApprovalChangeVO>> queryChangeHistory(@RequestParam Long id) {
        List<SchemeApprovalChangeVO> vo = service.queryChangeHistory(id);
        return CommonResponse.success(vo);
    }

}
