package com.ejianc.business.scheme.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scheme.bean.SchemeApprovalEntity;
import com.ejianc.business.scheme.bean.SchemeApprovalMarkEntity;
import com.ejianc.business.scheme.service.ISchemeApprovalMarkService;
import com.ejianc.business.scheme.service.ISchemeApprovalService;
import com.ejianc.business.scheme.vo.SchemeApprovalHistoryVO;
import com.ejianc.business.scheme.vo.SchemeApprovalMarkVO;
import com.ejianc.business.scheme.vo.SchemeApprovalVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 施工方案报批实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("schemeApproval")
public class SchemeApprovalController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;
    
    @Autowired
    private ISchemeApprovalService service;

    @Autowired
    private ISchemeApprovalMarkService markService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SchemeApprovalVO> saveOrUpdate(@RequestBody SchemeApprovalVO saveorUpdateVO) {
        CommonResponse<SchemeApprovalVO> response = service.saveOrUpdate(saveorUpdateVO);
        return response;
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemeApprovalVO> queryDetail(Long id) {
    	SchemeApprovalEntity entity = service.selectById(id);
    	SchemeApprovalVO vo = BeanMapper.map(entity, SchemeApprovalVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SchemeApprovalVO> vos) {
        return service.delete(vos);
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SchemeApprovalVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("schemeGradeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        
        IPage<SchemeApprovalEntity> page = service.queryPage(param,false);
        IPage<SchemeApprovalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SchemeApprovalVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 方案评审管理台账
     * @Param param: 
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.business.scheme.vo.SchemeApprovalVO>>
     * @Author songlx
     * @Date \
     **/
    @RequestMapping(value = "/markReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SchemeApprovalVO>> markReport(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("schemeGradeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SchemeApprovalEntity> page = service.queryPage(param,false);
        IPage<SchemeApprovalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SchemeApprovalVO> records = BeanMapper.mapList(page.getRecords(), SchemeApprovalVO.class);
        if(!CollectionUtils.isEmpty(records)){
            List<Long> pIds = records.stream().map(SchemeApprovalVO::getId).collect(Collectors.toList());
            QueryParam qryMap = new QueryParam();
            qryMap.getParams().put("approvalId", new Parameter(QueryParam.IN, pIds));
            List<SchemeApprovalMarkEntity> schemeApprovalMarkEntities = markService.queryList(qryMap);
            if(!CollectionUtils.isEmpty(schemeApprovalMarkEntities)){
                List<SchemeApprovalMarkVO> schemeApprovalMarkVOS = BeanMapper.mapList(schemeApprovalMarkEntities, SchemeApprovalMarkVO.class);
                Map<Long, List<SchemeApprovalMarkVO>> groupList = schemeApprovalMarkVOS.stream().collect(Collectors.groupingBy(SchemeApprovalMarkVO::getApprovalId));
                for(SchemeApprovalVO vo : records){
                    vo.setMarkList(groupList.get(vo.getId()));
                }
            }

        }
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    

}
