package com.ejianc.business.scheme.controller;

import java.io.Serializable;

import com.ejianc.business.scheme.service.ISchemeCategoryService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.scheme.bean.SchemeDocEntity;
import com.ejianc.business.scheme.service.ISchemeDocService;
import com.ejianc.business.scheme.vo.SchemeDocVO;

/**
 * 施工方案
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("schemeDoc")
public class SchemeDocController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ISchemeDocService service; 
    @Autowired
    private ISchemeCategoryService Categoryservice;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SchemeDocVO> saveOrUpdate(@RequestBody SchemeDocVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemeDocVO> queryDetail(Long id) {
    	SchemeDocEntity entity = service.selectById(id);
    	SchemeDocVO vo = BeanMapper.map(entity, SchemeDocVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if(ListUtil.isEmpty(ids)){
            return CommonResponse.success("删除失败：主键为空！");
        }else{
            service.removeByIds(ids);
        }
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SchemeDocVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isBlank(param.getParams().get("categoryId").getValue().toString())){
            IPage<SchemeDocVO> pageData = new Page<>(1, 10, 0);
            pageData.setRecords(new ArrayList<>());
            return CommonResponse.success("查询列表数据成功！",pageData);
        }else{
            List<Long> ids=Categoryservice.getChildIds(Long.parseLong(param.getParams().get("categoryId").getValue().toString()));
            param.getParams().put("categoryId", new Parameter(QueryParam.IN, ids));
            IPage<SchemeDocEntity> page = service.queryPage(param,false);
            IPage<SchemeDocVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), SchemeDocVO.class));
            return CommonResponse.success("查询列表数据成功！",pageData);
        }

        

    }
    /**
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SchemeDocVO>> queryRef(@RequestParam(defaultValue = "1") int pageNumber,
                                                       @RequestParam(defaultValue = "10") int pageSize,
                                                       @RequestParam(required=false) String relyCondition,
                                                       @RequestParam(required=false) String searchText) {
        QueryParam param=new QueryParam();
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("schemeCode");
        param.getFuzzyFields().add("schemeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotBlank(relyCondition)){
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            List<Long> ids=Categoryservice.getChildIds(categoryId);
            param.getParams().put("categoryId", new Parameter(QueryParam.IN, ids));
        }
        IPage<SchemeDocEntity> page = service.queryPage(param,false);
        IPage<SchemeDocVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SchemeDocVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
