package com.ejianc.business.scheme.controller;

import java.io.Serializable;

import com.ejianc.business.scheme.bean.SchemePlanDetailChangeEntity;
import com.ejianc.business.scheme.bean.SchemePlanEntity;
import com.ejianc.business.scheme.enums.ChangeStatusEnum;
import com.ejianc.business.scheme.service.ISchemePlanService;
import com.ejianc.business.scheme.vo.SchemePlanDetailChangeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.scheme.bean.SchemePlanChangeEntity;
import com.ejianc.business.scheme.service.ISchemePlanChangeService;
import com.ejianc.business.scheme.vo.SchemePlanChangeVO;

/**
 * 施工方案计划修订实体
 *
 * @author generator
 */
@Controller
@RequestMapping("schemePlanChange")
public class SchemePlanChangeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISchemePlanChangeService service;

    @Autowired
    private ISchemePlanService planService;

    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SchemePlanChangeVO> saveOrUpdate(@RequestBody SchemePlanChangeVO saveOrUpdateVO) {
        //校验项目是否存在未完成的变更计划单存在
        SchemePlanChangeEntity entity = BeanMapper.map(saveOrUpdateVO, SchemePlanChangeEntity.class);
        if (ChangeStatusEnum.变更中.getCode() == entity.getChangeState()) {
            throw new BusinessException("该施工方按计划存在变更中单据，不允许保存!");
        }
        SchemePlanEntity masterPlan = planService.getById(saveOrUpdateVO.getPlanId());
        UserContext userContext = sessionManager.getUserContext();
        SchemePlanChangeEntity saveEntity = null;
        if (null == saveOrUpdateVO.getId()) {

            saveEntity = BeanMapper.map(saveOrUpdateVO, SchemePlanChangeEntity.class);
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());

            saveEntity.setBillCode(masterPlan.getBillCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());

        } else {
            saveEntity = service.getById(saveOrUpdateVO.getId());
            saveEntity.setProjectId(saveOrUpdateVO.getProjectId());
            saveEntity.setProjectName(saveOrUpdateVO.getProjectName());
            saveEntity.setRemark(saveOrUpdateVO.getRemark());
            saveEntity.setBillCode(saveOrUpdateVO.getBillCode());
            saveEntity.setModifyUserName(userContext.getUserName());

        }
        saveEntity.setPlanDetail(BeanMapper.mapList(saveOrUpdateVO.getPlanDetail(), SchemePlanDetailChangeEntity.class));
        SchemePlanChangeEntity schemePlanChangeEntity = service.saveOrUpdatePlan(saveEntity);
        return CommonResponse.success("保存成功！", BeanMapper.map(schemePlanChangeEntity, SchemePlanChangeVO.class));

    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemePlanChangeVO> queryDetail(Long id) {
        SchemePlanChangeEntity entity = service.selectById(id);
        SchemePlanChangeVO vo = BeanMapper.map(entity, SchemePlanChangeVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SchemePlanChangeVO> vos) {
        service.deleteChangePlan(vos.stream().map(SchemePlanChangeVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SchemePlanChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<SchemePlanChangeEntity> page = service.queryPage(param, false);
        IPage<SchemePlanChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SchemePlanChangeVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

}
