package com.ejianc.business.scheme.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scheme.bean.SchemePlanDetailEntity;
import com.ejianc.business.scheme.bean.SchemePlanEntity;
import com.ejianc.business.scheme.cons.PlanCons;
import com.ejianc.business.scheme.enums.ChangeStatusEnum;
import com.ejianc.business.scheme.service.ISchemePlanDetailService;
import com.ejianc.business.scheme.service.ISchemePlanHistoryService;
import com.ejianc.business.scheme.service.ISchemePlanService;
import com.ejianc.business.scheme.vo.SchemePlanDetailVO;
import com.ejianc.business.scheme.vo.SchemePlanHistoryVO;
import com.ejianc.business.scheme.vo.SchemePlanRefVO;
import com.ejianc.business.scheme.vo.SchemePlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 施工方案计划
 *
 * @author generator
 */
@Controller
@RequestMapping("schemePlan")
public class SchemePlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ISchemePlanService service;

    @Autowired
    private ISchemePlanDetailService planDetailService;

    @Autowired
    private ISchemePlanHistoryService schemePlanHistoryService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SchemePlanVO> saveOrUpdate(@RequestBody SchemePlanVO saveOrUpdateVO) {
        SchemePlanEntity entity = BeanMapper.map(saveOrUpdateVO, SchemePlanEntity.class);

        //新增设定初始版本号
        if (null == entity.getId()) {
            CommonResponse<String> codeResp = billCodeApi.getCodeBatchByRuleCode(PlanCons.SCHEME_PLAN_CODE, InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error("保存失败，获取自动编码失败！");
            }
            entity.setBillCode(codeResp.getData());
            entity.setChangeVersion(1);
            List<SchemePlanDetailVO> planDetail = saveOrUpdateVO.getPlanDetail();
            entity.setPlanCount(CollectionUtil.isEmpty(planDetail) ? 0 : planDetail.size());
            entity.setFinishCount(0);
            entity.setChangeState(ChangeStatusEnum.未变更.getCode());
        }
        service.saveOrUpdate(entity, false);
        SchemePlanVO vo = BeanMapper.map(entity, SchemePlanVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemePlanVO> queryDetail(Long id) {
        SchemePlanEntity entity = service.selectById(id);
        SchemePlanVO vo = BeanMapper.map(entity, SchemePlanVO.class);
        List<SchemePlanHistoryVO> hisList = schemePlanHistoryService.queryHistoryByPlanId(vo.getId());
        vo.setPlanHistory(hisList);

        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SchemePlanVO> vos) {
        service.removeByIds(vos.stream().map(SchemePlanVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SchemePlanVO>> queryList(@RequestBody QueryParam param) {
        /** 搜索：1、编号；2、项目名称； 3、建设单位；*/
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "orgName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SchemePlanEntity> page = service.queryPage(param, false);
        IPage<SchemePlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SchemePlanVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 方案计划参照
     *
     * @Param pageNumber:
     * @Param pageSize:
     * @Param condition:
     * @Param searchText:
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.scheme.vo.SchemePlanRefVO>>
     * @Author songlx
     * @Date 2021-03-25
     **/
    @RequestMapping(value = "/schemePlanRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SchemePlanRefVO>> schemePlanRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                                @RequestParam(defaultValue = "10") Integer pageSize,
                                                                @RequestParam(value = "condition", required = false) String condition,
                                                                @RequestParam(value = "searchText", required = false) String searchText) {

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("schemeName");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));

        Page<SchemePlanRefVO> page = new Page<>((long) queryParam.getPageIndex(), (long) queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<SchemePlanRefVO> list = service.querySchemePlanRef(page, wrapper);
        IPage<SchemePlanRefVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(list, SchemePlanRefVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * 导出
     * @Param param:
     * @Param response:
     * @Return void
     * @Author songlx
     * @Date 2021-03-29
     **/
    @PostMapping("excelExport")
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        service.excelExport(param, response);
    }


    @PostMapping("updateFinishState")
    @ResponseBody
    public void updateFinishState(SchemePlanDetailEntity entity) {
        planDetailService.updateFinishState(entity);
    }

}
