package com.ejianc.business.scheme.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scheme.bean.SchemeApprovalChangeEntity;
import com.ejianc.business.scheme.bean.SchemeApprovalEntity;
import com.ejianc.business.scheme.enums.ChangeStatusEnum;
import com.ejianc.business.scheme.mapper.SchemeApprovalChangeMapper;
import com.ejianc.business.scheme.service.ISchemeApprovalChangeService;
import com.ejianc.business.scheme.service.ISchemeApprovalService;
import com.ejianc.business.scheme.vo.SchemeApprovalChangeVO;
import com.ejianc.business.scheme.vo.SchemeApprovalVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 施工方案报批变更实体
 * 
 * @author generator
 * 
 */
@Service("schemeApprovalChangeService")
public class SchemeApprovalChangeServiceImpl extends BaseServiceImpl<SchemeApprovalChangeMapper, SchemeApprovalChangeEntity> implements ISchemeApprovalChangeService{

    private static final String BILL_CODE_ROLE = "SCHEME_APPROVAL_CHANGE_CODE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ISchemeApprovalService approvalService;

    @Override
    public CommonResponse<SchemeApprovalChangeVO> saveOrUpdate(SchemeApprovalChangeVO saveorUpdateVO) {
        SchemeApprovalChangeEntity entity = BeanMapper.map(saveorUpdateVO, SchemeApprovalChangeEntity.class);
        // 1.自动生成编码
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 2.保存前
        if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
            entity.setChangeVersion(1);//第一次变更
        } else {
            entity.setChangeVersion(entity.getChangeVersion() + 1);//版本号+1
        }
        if (2 == entity.getChangeStatus()) {
            throw new BusinessException("合同存在变更中单据，不允许保存!");
        }

        // 3.保存
        super.saveOrUpdate(entity, false);

        // 4.保存后
        LambdaUpdateWrapper<SchemeApprovalEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(SchemeApprovalEntity::getChangeId, entity.getId());//变更主键
        updateWrapper.set(SchemeApprovalEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());//状态：变更中
        updateWrapper.set(SchemeApprovalEntity::getChangeCode, entity.getBillCode());//变更编码
        updateWrapper.eq(SchemeApprovalEntity::getId, entity.getSourceId());
        approvalService.update(updateWrapper);

        return CommonResponse.success(BeanMapper.map(entity, SchemeApprovalChangeVO.class));
    }

    @Override
    public void deleteChange(List<SchemeApprovalChangeVO> vos) {
        for (SchemeApprovalChangeVO vo : vos) {
            SchemeApprovalChangeEntity changeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<SchemeApprovalEntity> updateWrapper = new LambdaUpdateWrapper<>();
            if (changeEntity.getChangeVersion() == 1) {
                updateWrapper.set(SchemeApprovalEntity::getChangeStatus, ChangeStatusEnum.未变更.getCode());
            } else {
                updateWrapper.set(SchemeApprovalEntity::getChangeStatus, ChangeStatusEnum.已变更.getCode());
            }
            updateWrapper.eq(SchemeApprovalEntity::getId, changeEntity.getSourceId());
            approvalService.update(updateWrapper);
            super.removeById(vo, false);
        }
    }

    @Override
    public SchemeApprovalVO queryDetailChange(Long id) {
        SchemeApprovalEntity entity = approvalService.selectById(id);
        if(entity != null){
            SchemeApprovalVO vo = BeanMapper.map(entity, SchemeApprovalVO.class);
            vo.setBillState(null);
            vo.setCreateUserCode(null);
            vo.setCreateTime(null);
            vo.setUpdateUserCode(null);
            vo.setUpdateTime(null);
            return vo;
        }
        return null;
    }

    @Override
    public List<SchemeApprovalChangeVO> queryChangeHistory(Long id) {
        LambdaQueryWrapper<SchemeApprovalChangeEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SchemeApprovalChangeEntity::getSourceId, id);
        lambda.in(SchemeApprovalChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.orderByDesc(SchemeApprovalChangeEntity::getUsedTime);
        List<SchemeApprovalChangeEntity> list = baseMapper.selectList(lambda);
        if (null != list && list.size() > 0) {
            List<SchemeApprovalChangeVO> voList = BeanMapper.mapList(list, SchemeApprovalChangeVO.class);
            for (SchemeApprovalChangeVO vo : voList) {
                String historyBillCode = vo.getBillCode() + "-" + vo.getChangeVersion();
                vo.setHistoryBillCode(historyBillCode);
            }
            return voList;
        }
        return null;
    }

}
