package com.ejianc.business.scheme.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.scheme.bean.SchemeApprovalEntity;
import com.ejianc.business.scheme.bean.SchemePlanDetailEntity;
import com.ejianc.business.scheme.cons.PlanCons;
import com.ejianc.business.scheme.mapper.SchemeApprovalMapper;
import com.ejianc.business.scheme.service.ISchemeApprovalService;
import com.ejianc.business.scheme.service.ISchemePlanDetailService;
import com.ejianc.business.scheme.vo.SchemeApprovalVO;
import com.ejianc.business.scheme.vo.SqlParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 施工方案报批实体
 * 
 * @author generator
 * 
 */
@Service("schemeApprovalService")
public class SchemeApprovalServiceImpl extends BaseServiceImpl<SchemeApprovalMapper, SchemeApprovalEntity> implements ISchemeApprovalService{

    private static final String BILL_CODE_ROLE = "SCHEME_APPROVAL_CODE";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ISchemePlanDetailService planDetailService;

    @Override
    public CommonResponse<SchemeApprovalVO> saveOrUpdate(SchemeApprovalVO saveorUpdateVO) {
        SchemeApprovalEntity data = super.getById(saveorUpdateVO.getId());// 新增时为null

        SchemeApprovalEntity entity = BeanMapper.map(saveorUpdateVO, SchemeApprovalEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);

        // 回写计划清单已编制
        SchemePlanDetailEntity planDetail = planDetailService.getById(saveorUpdateVO.getSchemeId());
        planDetail.setFinishState(PlanCons.YES);
        planDetailService.updateFinishState(planDetail);
        // 计划清单修改，回写原计划清单未编制
        if(data != null && !saveorUpdateVO.getSchemeId().equals(data.getSchemeId())){
            SchemePlanDetailEntity oldPlanDetail = planDetailService.getById(data.getSchemeId());
            oldPlanDetail.setFinishState(PlanCons.NO);
            planDetailService.updateFinishState(oldPlanDetail);
        }
        return CommonResponse.success(BeanMapper.map(entity, SchemeApprovalVO.class));
    }

    @Override
    public CommonResponse<String> delete(List<SchemeApprovalVO> vos) {
        List<Long> ids = vos.stream().map(SchemeApprovalVO::getId).collect(Collectors.toList());
        List<SchemeApprovalEntity> list = super.list(new QueryWrapper<SchemeApprovalEntity>().in("id", ids));
        List<Long> schemeIds = list.stream().map(SchemeApprovalEntity::getSchemeId).collect(Collectors.toList());
        super.removeByIds(ids,true);
        // 回写计划清单未编制
        for(Long schemeId : schemeIds){
            SchemePlanDetailEntity planDetail = planDetailService.getById(schemeId);
            planDetail.setFinishState(PlanCons.NO);
            planDetailService.updateFinishState(planDetail);
        }
        return CommonResponse.success("删除成功！");
    }

    @Override
    public List<Map<String, Object>> queryArgumentDateDueWarn(List<SqlParam> sqlParamList) {
        return baseMapper.queryArgumentDateDueWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryArgumentDateOverWarn(List<SqlParam> sqlParamList) {
        return baseMapper.queryArgumentDateOverWarn(sqlParamList);
    }
}
