package com.ejianc.business.scheme.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.scheme.cons.PartCons;
import com.ejianc.business.scheme.utils.InnerCodeTool;
import com.ejianc.business.scheme.vo.SchemeCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scheme.mapper.SchemeCategoryMapper;
import com.ejianc.business.scheme.bean.SchemeCategoryEntity;
import com.ejianc.business.scheme.service.ISchemeCategoryService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 施工方案档案
 *
 * @author generator
 */
@Service("schemeCategoryService")
public class SchemeCategoryServiceImpl extends BaseServiceImpl<SchemeCategoryMapper, SchemeCategoryEntity> implements ISchemeCategoryService {

    @Override
    public CommonResponse<SchemeCategoryVO> saveOrUpdate(SchemeCategoryVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SchemeCategoryEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            SchemeCategoryEntity oldEntity = baseMapper.selectById(saveorUpdateVO.getId());
            entity = BeanMapper.map(oldEntity, SchemeCategoryEntity.class);
            entity.setCode(saveorUpdateVO.getCode());
            entity.setName(saveorUpdateVO.getName());
            entity.setParentId(saveorUpdateVO.getParentId());
            QueryParam param = new QueryParam();
            param.getParams().put("inner_code", new Parameter(QueryParam.LIKE, oldEntity.getInnerCode()));
            param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
            List<SchemeCategoryEntity> oldEntities = super.queryList(param);
            //原本没有父级，现在有
            if ((oldEntity.getParentId() == null || oldEntity.getParentId() <= 0)
                    && (entity.getParentId() != null && entity.getParentId() > 0)) {
                SchemeCategoryEntity parentEntity = baseMapper.selectById(entity.getParentId());
                for (SchemeCategoryEntity sce : oldEntities) {
                    if (sce.getId() == entity.getId()) {
                        sce = entity;
                    }
                    sce.setInnerCode(parentEntity.getInnerCode() + "|" + sce.getInnerCode());
                }
                super.updateBatchById(oldEntities);
                return CommonResponse.success("修改成功！");
            }
            //原本有父级，现在没有
            if ((entity.getParentId() == null || entity.getParentId() <= 0)
                    && (oldEntity.getParentId() != null && oldEntity.getParentId() > 0)) {
                for (SchemeCategoryEntity sce : oldEntities) {
                    if (sce.getId() == entity.getId()) {
                        sce = entity;
                    }
                    sce.getInnerCode().replaceAll(oldEntity.getInnerCode(), oldEntity.getId().toString());
                }
                super.updateBatchById(oldEntities);
                return CommonResponse.success("修改成功！");
            }
            //原本有父级，现在改变了
            if ((entity.getParentId() != null && entity.getParentId() > 0)
                    && (oldEntity.getParentId() != null && oldEntity.getParentId() > 0)
                    && entity.getParentId() != oldEntity.getParentId()) {
                SchemeCategoryEntity parentEntity = baseMapper.selectById(entity.getParentId());
                for (SchemeCategoryEntity sce : oldEntities) {
                    if (sce.getId() == entity.getId()) {
                        sce = entity;
                    }
                    String innerCode = sce.getInnerCode().replaceAll(oldEntity.getInnerCode(), parentEntity.getInnerCode() + "|" + oldEntity.getId());
                    sce.setInnerCode(innerCode);
                }
                super.updateBatchById(oldEntities);
                return CommonResponse.success("修改成功！");
            }
            super.saveOrUpdate(entity,false);
            return CommonResponse.success("修改成功！");
        } else {//新增
            entity = BeanMapper.map(saveorUpdateVO, SchemeCategoryEntity.class);
            entity.setId(IdWorker.getId());
            if (StringUtils.isBlank(entity.getCode())) {
                entity.setCode(creatCode(entity.getParentId(), tenantId));
            }
            if (entity.getParentId() != null && entity.getParentId() > 0) {
                SchemeCategoryEntity uniqueBean = baseMapper.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    @Override
    public List<SchemeCategoryEntity> queryListByPid(Long id) {
        SchemeCategoryEntity entity = baseMapper.selectById(id);
        QueryParam param = new QueryParam();
        param.getParams().put("inner_code", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
        param.getParams().put("id", new Parameter(QueryParam.NE, id));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<SchemeCategoryEntity> oldEntities = super.queryList(param);
        return oldEntities;
    }

    @Override
    public List<Long> getChildIds(Long id) {
        SchemeCategoryEntity entity = baseMapper.selectById(id);
        QueryParam param = new QueryParam();
        param.getParams().put("inner_code", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<SchemeCategoryEntity> oldEntities = super.queryList(param);
        return oldEntities.stream().map(SchemeCategoryEntity::getId).collect(Collectors.toList());
    }

    /**
     * 生成编码
     * @param pid
     * @param tenantid
     * @return
     */
    private String creatCode(Long pid, Long tenantid) {
        // 获取最大的code 暂不考虑并发问题、几率很小
        String pcode = "";
        if (pid != null && pid > 0) {
            pcode = getPcode(pid);
        }
        String getMaxCode = baseMapper.getMaxCode(tenantid, pcode, PartCons.CATEGORY_LENGTH);
        String nextValue = InnerCodeTool.getNextValue(getMaxCode, PartCons.CATEGORY_LENGTH);
        return pcode + nextValue;
    }
    @Override
    public String getPcode(Long id){
        return baseMapper.getPcode(id);
    }
}
