package com.ejianc.business.scheme.service.impl;

import com.ejianc.business.scheme.cons.PartCons;
import com.ejianc.business.scheme.service.ISchemeCategoryService;
import com.ejianc.business.scheme.utils.InnerCodeTool;
import com.ejianc.business.scheme.vo.SchemeDocVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scheme.mapper.SchemeDocMapper;
import com.ejianc.business.scheme.bean.SchemeDocEntity;
import com.ejianc.business.scheme.service.ISchemeDocService;

import java.util.List;

/**
 * 施工方案
 *
 * @author generator
 */
@Service("schemeDocService")
public class SchemeDocServiceImpl extends BaseServiceImpl<SchemeDocMapper, SchemeDocEntity> implements ISchemeDocService {
    @Autowired
    private ISchemeCategoryService categoryService;

    @Override
    public List<SchemeDocEntity> queryListByCategoryId(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("category_id", new Parameter(QueryParam.LIKE, id));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<SchemeDocEntity> oldEntities = super.queryList(param);
        return oldEntities;
    }

    @Override
    public CommonResponse<SchemeDocVO> saveOrUpdate(SchemeDocVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SchemeDocEntity entity = BeanMapper.map(saveorUpdateVO, SchemeDocEntity.class);
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity.setTenantId(tenantId);
            super.saveOrUpdate(entity, false);
            SchemeDocVO vo = BeanMapper.map(entity, SchemeDocVO.class);
            return CommonResponse.success("保存或修改单据成功！", vo);
        } else {//新增
            if (StringUtils.isBlank(entity.getSchemeCode())) {
                entity.setSchemeCode(creatCode(entity.getCategoryId(), tenantId));
            }
            super.saveOrUpdate(entity, false);
            SchemeDocVO vo = BeanMapper.map(entity, SchemeDocVO.class);
            return CommonResponse.success("保存或修改单据成功！", vo);
        }
    }

    /**
     * 生成编码
     *
     * @param tenantid
     * @return
     */
    private String creatCode(Long pid, Long tenantid) {
        String pcode = categoryService.getPcode(pid);
        String getMaxCode = baseMapper.getMaxCode(pcode, tenantid, PartCons.DOC_LENGTH);
        String nextValue = InnerCodeTool.getNextValue(getMaxCode, PartCons.DOC_LENGTH);
        return pcode + nextValue;
    }
}
