package com.ejianc.business.scheme.service.impl;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.scheme.bean.*;
import com.ejianc.business.scheme.cons.BillCons;
import com.ejianc.business.scheme.cons.PlanCons;
import com.ejianc.business.scheme.enums.ChangeStatusEnum;
import com.ejianc.business.scheme.service.ISchemePlanChangeService;
import com.ejianc.business.scheme.service.ISchemePlanDetailService;
import com.ejianc.business.scheme.service.ISchemePlanHistoryService;
import com.ejianc.business.scheme.service.ISchemePlanService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("schemePlanChange")
public class SchemePlanChangeBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private ISchemePlanService planService;

    @Autowired
    private ISchemePlanDetailService planDetailService;


    @Autowired
    private ISchemePlanChangeService planChangeService;


    @Autowired
    private ISchemePlanHistoryService planHistoryService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private SessionManager sessionManager;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //此处billId即为单据Id
        SchemePlanChangeEntity entity = planChangeService.selectById(billId);
        UserContext userContext = sessionManager.getUserContext();
        //设置提交人信息
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());

        planChangeService.saveOrUpdate(entity, false);

        return CommonResponse.success("施工方案计划变更提交审批回调成功！");
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("总计划变更审批完成回调处理：billId: {}, state: {}", billId, state);

        SchemePlanChangeEntity planChange = planChangeService.selectById(billId);
        SchemePlanEntity newPlanEntity = null;
        SchemePlanEntity oldPlan = planService.selectById(planChange.getPlanId());

        if (state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            //直审时记录
            UserContext userContext = sessionManager.getUserContext();
            //设置提交人信息
            planChange.setCommitDate(new Date());
            planChange.setCommitUserCode(userContext.getUserCode());
            planChange.setCommitUserName(userContext.getUserName());
        }
        //设置总计划变更单据生效时间
        planChange.setEffectiveDate(new Date());

        //1、复制合同信息到合同记录
        SchemePlanHistoryEntity recordEntity = BeanMapper.map(oldPlan, SchemePlanHistoryEntity.class);
        logger.info("施工方案计划变更审批完成回调, 变更后信息：【{}】, 变更前信息: 【{}】", JSON.toJSONString(planChange), JSON.toJSONString(oldPlan));

        //设置总计划Id
        recordEntity.setPlanId(oldPlan.getId());
        //Id置为空
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getPlanDetail())) {
            recordEntity.getPlanDetail().stream().forEach(detail -> {
                //设置变更明细id
                detail.setDetailId(detail.getId());
                detail.setPlanId(recordEntity.getId());
                detail.setId(null);
            });
        }

        //设置编制人等信息
        recordEntity.setCreateUserCode(planChange.getCreateUserCode());
        recordEntity.setCreateTime(planChange.getCreateTime());
        recordEntity.setCreateUserName(planChange.getCreateUserName());
        recordEntity.setModifyUserName(planChange.getModifyUserName());
        recordEntity.setUpdateTime(planChange.getUpdateTime());
        recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
        recordEntity.setCommitDate(planChange.getCommitDate());
        recordEntity.setCommitUserCode(planChange.getCommitUserCode());
        recordEntity.setCommitUserName(planChange.getCommitUserName());
        recordEntity.setEffectiveDate(planChange.getEffectiveDate());
        recordEntity.setChangeReason(planChange.getChangeReason());
        //变更记录保存
        recordEntity.setEffectiveDate(new Date());
        planHistoryService.saveOrUpdate(recordEntity, false);

        planChangeService.saveOrUpdate(planChange, false);

        //修改总计划字段
        newPlanEntity = BeanMapper.map(planChange, SchemePlanEntity.class);
        //变更状态-已变更
        newPlanEntity.setChangeState(ChangeStatusEnum.已变更.getCode());

        //清空当前变更计划id
        newPlanEntity.setChangeId(null);
        //合同初始创建信息
        newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
        newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
        newPlanEntity.setCreateTime(oldPlan.getCreateTime());
        newPlanEntity.setId(oldPlan.getId());
        newPlanEntity.setVersion(oldPlan.getVersion());
        newPlanEntity.setChangeVersion(planChange.getChangeVersion());
        //子表信息设置
        Map<Long, Integer> map = oldPlan.getPlanDetail().stream().collect(Collectors.toMap(SchemePlanDetailEntity::getId, SchemePlanDetailEntity::getVersion));

        if (CollectionUtils.isNotEmpty(planChange.getPlanDetail())) {
            List<SchemePlanDetailEntity> list = new ArrayList<>();
            SchemePlanDetailEntity tmp = null;
            for (SchemePlanDetailChangeEntity detail : planChange.getPlanDetail()) {
                tmp = BeanMapper.map(detail, SchemePlanDetailEntity.class);
                Long detailId = detail.getDetailId();
                if (null != detail.getDetailId()) {
                    tmp.setId(detailId);
                    tmp.setVersion(map.get(detailId));
                    tmp.setRowState("update");
                    list.add(tmp);
                    map.remove(detailId);
                } else {
                    tmp.setRowState("add");
                    list.add(tmp);
                }
            }
            newPlanEntity.setPlanDetail(list);
        }
        //删除已有子表
        if (map.size() > 0) {
            map.keySet();
            planService.delByPlanIdAndDetailIds(new ArrayList<>(map.keySet()), oldPlan.getId());
        }

        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
                String.valueOf(billId), PlanCons.BILL_TYPE_PLAN_CHANGE, PlanCons.FILE_FLAG,
                String.valueOf(oldPlan.getId()), PlanCons.BILL_TYPE_PLAN, PlanCons.FILE_FLAG);

        if (planService.saveOrUpdate(newPlanEntity, false)) {
            return CommonResponse.success("回调业务处理成功！");
        }
        return CommonResponse.success("回调业务处理失败！");
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("变更单暂不支持回退功能!");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
