package com.ejianc.business.scheme.service.impl;

import com.ejianc.business.scheme.bean.SchemePlanEntity;
import com.ejianc.business.scheme.cons.PlanCons;
import com.ejianc.business.scheme.service.ISchemePlanService;
import com.ejianc.business.scheme.vo.SqlParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scheme.mapper.SchemePlanDetailMapper;
import com.ejianc.business.scheme.bean.SchemePlanDetailEntity;
import com.ejianc.business.scheme.service.ISchemePlanDetailService;

import java.util.List;
import java.util.Map;

/**
 * 施工方案计划明细
 *
 * @author generator
 */
@Service("schemePlanDetailService")
public class SchemePlanDetailServiceImpl extends BaseServiceImpl<SchemePlanDetailMapper, SchemePlanDetailEntity> implements ISchemePlanDetailService {

    @Autowired
    private ISchemePlanService planService;


    @Override
    public List<Map<String, Object>> makeDatePreWarn(List<SqlParam> sqlParamList) {
        return baseMapper.makeDatePreWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> makeDateOverWarn(List<SqlParam> sqlParamList) {
        return baseMapper.makeDateOverWarn(sqlParamList);
    }

    @Override
    public SchemePlanDetailEntity updateFinishState(SchemePlanDetailEntity entity) {
        Integer finishState = entity.getFinishState();
        if (null != entity.getId() && finishState != null) {
            entity = baseMapper.selectById(entity.getId());
            entity.setFinishState(finishState);
            baseMapper.updateById(entity);
            if (null != entity.getPId()) {
                SchemePlanEntity planEntity = planService.getById(entity.getPId());
                Integer finishCount = planEntity.getFinishCount();
                //已编制
                if (PlanCons.YES == finishState) {
                    planEntity.setFinishCount(finishCount + 1);
                } else {
                    planEntity.setFinishCount(finishCount != 0 ? (finishCount - 1) : 0);
                }
                planService.updateById(planEntity);
            }
        }
        return entity;
    }
}
