package com.ejianc.business.scheme.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.scheme.bean.SchemePlanHistoryEntity;
import com.ejianc.business.scheme.mapper.SchemePlanHistoryMapper;
import com.ejianc.business.scheme.service.ISchemePlanHistoryService;
import com.ejianc.business.scheme.vo.SchemePlanHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 施工方案计划历史实体
 *
 * @author generator
 */
@Service("schemePlanHistoryService")
public class SchemePlanHistoryServiceImpl extends BaseServiceImpl<SchemePlanHistoryMapper, SchemePlanHistoryEntity> implements ISchemePlanHistoryService {


    /**
     * 根据原计划id查询历史记录
     *
     * @param id id
     * @Return java.util.List<com.ejianc.business.scheme.vo.SchemePlanHistoryVO>
     * @Author songlx
     * @Date 2021-03-25
     */
    @Override
    public List<SchemePlanHistoryVO> queryHistoryByPlanId(Long id) {
        List<SchemePlanHistoryVO> resp = new ArrayList<>();
        LambdaQueryWrapper<SchemePlanHistoryEntity> hisQuery = new LambdaQueryWrapper<>();
        hisQuery.eq(SchemePlanHistoryEntity::getPlanId, id);
        hisQuery.orderByDesc(SchemePlanHistoryEntity::getCreateTime);
        List<SchemePlanHistoryEntity> list = this.list(hisQuery);
        if (CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, SchemePlanHistoryVO.class);
        }
        return resp;
    }
}
