package com.ejianc.business.scheme.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scheme.vo.SchemePlanRefVO;
import com.ejianc.business.scheme.vo.SchemePlanVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scheme.mapper.SchemePlanMapper;
import com.ejianc.business.scheme.bean.SchemePlanEntity;
import com.ejianc.business.scheme.service.ISchemePlanService;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 施工方案计划
 *
 * @author generator
 */
@Service("schemePlanService")
public class SchemePlanServiceImpl extends BaseServiceImpl<SchemePlanMapper, SchemePlanEntity> implements ISchemePlanService {

    @Override
    public List<SchemePlanRefVO> querySchemePlanRef(Page<SchemePlanRefVO> page, QueryWrapper wrapper) {
        List<SchemePlanRefVO> list = baseMapper.querySchemePlanRef(page, wrapper);
        return list;
    }

    @Override
    public void delByPlanIdAndDetailIds(List<Long> detailIds, Long planId) {
        baseMapper.delByPlanIdAndDetailIds(detailIds, planId);
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "orgName"));
        param.getParams().put("tenant_id", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(10000);
        IPage<SchemePlanEntity> pageData = queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<SchemePlanVO> list = BeanMapper.mapList(pageData.getRecords(), SchemePlanVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("schemePlanExport.xlsx", beans, response);
        }
    }
}
