/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scheme.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scheme.bean.SchemeApprovalEntity;
import com.ejianc.business.scheme.bean.SchemePlanEntity;
import com.ejianc.business.scheme.service.ISchemeApprovalMarkService;
import com.ejianc.business.scheme.service.ISchemeApprovalService;
import com.ejianc.business.scheme.service.ISchemePlanService;
import com.ejianc.business.scheme.vo.SchemeApprovalMarkVO;
import com.ejianc.business.scheme.vo.SchemeApprovalReportVO;
import com.ejianc.business.scheme.vo.SchemeApprovalVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"schemeApproval"})
public class SchemeApprovalController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISchemeApprovalService service;
    @Autowired
    private ISchemeApprovalMarkService markService;
    @Autowired
    private ISchemePlanService planService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SchemeApprovalVO> saveOrUpdate(@RequestBody SchemeApprovalVO saveorUpdateVO) {
        CommonResponse<SchemeApprovalVO> response = this.service.saveOrUpdate(saveorUpdateVO);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SchemeApprovalVO> queryDetail(Long id) {
        SchemeApprovalEntity entity = (SchemeApprovalEntity)((Object)this.service.selectById(id));
        SchemeApprovalVO vo = (SchemeApprovalVO)BeanMapper.map((Object)((Object)entity), SchemeApprovalVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SchemeApprovalVO> vos) {
        return this.service.delete(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SchemeApprovalVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("schemeGradeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SchemeApprovalVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/markReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SchemeApprovalReportVO>> markReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("schemeGradeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), SchemeApprovalVO.class);
        ArrayList<SchemeApprovalReportVO> newRecords = new ArrayList<SchemeApprovalReportVO>();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List pIds = records.stream().map(BaseVO::getId).collect(Collectors.toList());
            QueryParam qryMap = new QueryParam();
            qryMap.getParams().put("approvalId", new Parameter("in", pIds));
            List schemeApprovalMarkEntities = this.markService.queryList(qryMap);
            if (!CollectionUtils.isEmpty((Collection)schemeApprovalMarkEntities)) {
                List schemeApprovalMarkVOS = BeanMapper.mapList((Iterable)schemeApprovalMarkEntities, SchemeApprovalMarkVO.class);
                HashMap<Long, SchemeApprovalVO> beanMap = new HashMap<Long, SchemeApprovalVO>();
                for (SchemeApprovalVO reportVO : records) {
                    beanMap.put(reportVO.getId(), reportVO);
                }
                for (SchemeApprovalMarkVO markVO : schemeApprovalMarkVOS) {
                    Long approvalId = markVO.getApprovalId();
                    SchemeApprovalReportVO newReportVO = (SchemeApprovalReportVO)BeanMapper.map(beanMap.get(approvalId), SchemeApprovalReportVO.class);
                    Long id = newReportVO.getId();
                    newReportVO.setId(markVO.getId());
                    newReportVO.setParentId(id);
                    newReportVO.setProcessInstanceId(markVO.getProcessInstanceId());
                    newReportVO.setAppriveIndex(markVO.getAppriveIndex());
                    newReportVO.setExpertId(markVO.getExpertId());
                    newReportVO.setExpertName(markVO.getExpertName());
                    newReportVO.setAppriveStartTime(markVO.getAppriveStartTime());
                    newReportVO.setAppriveEndTime(markVO.getAppriveEndTime());
                    newReportVO.setExpertOpion(markVO.getExpertOpion());
                    newReportVO.setMark(markVO.getMark());
                    newReportVO.setIsApprive(markVO.getIsApprive());
                    newRecords.add(newReportVO);
                }
            }
        }
        pageData.setRecords(newRecords);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SchemeApprovalReportVO>> queryReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("schemeGradeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<SchemeApprovalReportVO> list = this.service.queryReport((Page<SchemeApprovalReportVO>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/schemeDynamicReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SchemeApprovalReportVO>> schemeDynamicReport(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("schemeGradeName");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("engineeringTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), SchemeApprovalReportVO.class);
        if (!CollectionUtils.isEmpty((Collection)records)) {
            for (SchemeApprovalReportVO vo : records) {
                Period p = SchemeApprovalController.calculateTimeDifferenceByPeriod(vo.getCreateDate(), vo.getPlanCreateDate());
                vo.setDay(Integer.valueOf(p.getDays()));
                SchemePlanEntity plan = (SchemePlanEntity)((Object)this.planService.selectById(vo.getSchemePlanId()));
                vo.setEffectiveDate(plan != null ? plan.getEffectiveDate() : null);
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public static Period calculateTimeDifferenceByPeriod(Date date1, Date date2) {
        LocalDate localDate1 = date1.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Period p = Period.between(localDate1, localDate2);
        return p;
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        CommonResponse<IPage<SchemeApprovalVO>> res = this.queryList(param);
        List list = new ArrayList();
        if (res.isSuccess() && res.getData() != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)((IPage)res.getData()).getRecords())) {
            list = ((IPage)res.getData()).getRecords();
            list.forEach(vo -> {
                String isExpertArgumentName = "";
                isExpertArgumentName = vo.getIsExpertArgument() != null && vo.getIsExpertArgument().equals("1") ? "\u662f" : "\u5426";
                vo.setIsExpertArgumentName(isExpertArgumentName);
                String expertArgumentStateName = "";
                if (vo.getExpertArgumentState() != null && vo.getIsExpertArgument().equals("1")) {
                    expertArgumentStateName = "\u5df2\u8bba\u8bc1";
                }
                vo.setExpertArgumentStateName(expertArgumentStateName);
                String changeVersionName = "";
                DecimalFormat df = new DecimalFormat("00");
                Integer changeVersion = vo.getChangeVersion() != null ? vo.getChangeVersion() + 1 : 1;
                changeVersionName = df.format(changeVersion);
                if (vo.getChangeStatus() == 2) {
                    changeVersionName = "\u4fee\u8ba2\u4e2d-" + changeVersionName;
                }
                vo.setChangeVersionName(changeVersionName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("scheme-approval-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelDynamicReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelDynamicReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        CommonResponse<IPage<SchemeApprovalReportVO>> res = this.schemeDynamicReport(param);
        List list = new ArrayList();
        if (res.isSuccess() && res.getData() != null && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)((IPage)res.getData()).getRecords())) {
            list = ((IPage)res.getData()).getRecords();
            list.forEach(vo -> {
                String isExpertArgumentName = "";
                isExpertArgumentName = vo.getIsExpertArgument() != null && vo.getIsExpertArgument().equals("1") ? "\u662f" : "\u5426";
                vo.setIsExpertArgumentName(isExpertArgumentName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("scheme-dynamic-report-export.xlsx", beans, response);
    }
}

