/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scheme.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scheme.bean.SchemeApprovalEntity;
import com.ejianc.business.scheme.bean.SchemeApprovalMarkEntity;
import com.ejianc.business.scheme.cons.BillCons;
import com.ejianc.business.scheme.service.ISchemeApprovalMarkService;
import com.ejianc.business.scheme.service.ISchemeApprovalService;
import com.ejianc.business.scheme.utils.MathUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="schemeApproval")
public class SchemeApprovalBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SIGN = "mark";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISchemeApprovalService approvalService;
    @Autowired
    private ISchemeApprovalMarkService markService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        this.logger.info("-----------\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u524d\u56de\u8c03-----------");
        this.logger.info("sign-----------" + sign);
        if (SIGN.equals(sign)) {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(SchemeApprovalMarkEntity::getApprovalId, (Object)billId);
            lambda.eq(SchemeApprovalMarkEntity::getExpertId, (Object)InvocationInfoProxy.getUserid());
            lambda.ne(SchemeApprovalMarkEntity::getIsApprive, (Object)BillCons.NO);
            List markList = this.markService.list();
            if (CollectionUtils.isEmpty((Collection)markList)) {
                return CommonResponse.error((String)"\u672a\u6267\u884c\u65b9\u6848\u8bc4\u5206\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        this.logger.info("-----------\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u540e\u56de\u8c03-----------");
        this.logger.info("\u5f00\u59cb\u65f6\u95f4-----------" + other.get("taskStartTime"));
        this.logger.info("\u5ba1\u6279\u610f\u89c1-----------" + other.get("comment"));
        this.logger.info("other-----------" + other);
        if (SIGN.equals(sign)) {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(SchemeApprovalMarkEntity::getApprovalId, (Object)billId);
            lambda.eq(SchemeApprovalMarkEntity::getExpertId, (Object)InvocationInfoProxy.getEmployeeId());
            lambda.ne(SchemeApprovalMarkEntity::getIsApprive, (Object)BillCons.YES);
            List markList = this.markService.list((Wrapper)lambda);
            if (CollectionUtils.isNotEmpty((Collection)markList)) {
                SchemeApprovalMarkEntity mark = (SchemeApprovalMarkEntity)((Object)markList.get(0));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date appriveStartTime = new Date();
                try {
                    appriveStartTime = format.parse(String.valueOf(other.get("taskStartTime")));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                mark.setAppriveStartTime(appriveStartTime);
                mark.setAppriveEndTime(new Date());
                mark.setExpertOpion(String.valueOf(other.get("comment")));
                mark.setProcessInstanceId(Long.valueOf(taskId));
                mark.setIsApprive(BillCons.YES);
                this.markService.saveOrUpdate((Object)mark);
                this.calculateMark(billId);
            }
        }
        return CommonResponse.success();
    }

    private void calculateMark(Long billId) {
        BigDecimal averageMark = null;
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SchemeApprovalMarkEntity::getApprovalId, (Object)billId);
        lambda.eq(SchemeApprovalMarkEntity::getIsApprive, (Object)BillCons.YES);
        List markList = this.markService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)markList)) {
            for (SchemeApprovalMarkEntity vo : markList) {
                averageMark = MathUtil.safeAdd(averageMark, (BigDecimal)vo.getMark());
            }
            averageMark = MathUtil.safeDiv(averageMark, (BigDecimal)new BigDecimal(markList.size()));
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(SchemeApprovalEntity::getAverageMark, averageMark);
        updateWrapper.set(SchemeApprovalEntity::getIsMark, (Object)BillCons.YES);
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        this.approvalService.update((Wrapper)updateWrapper);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u64a4\u56de\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(SchemeApprovalMarkEntity::getApprovalId, (Object)billId);
        lambda.eq(SchemeApprovalMarkEntity::getIsApprive, (Object)BillCons.YES);
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List markList = this.markService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)markList)) {
            SchemeApprovalMarkEntity mark = (SchemeApprovalMarkEntity)((Object)markList.get(0));
            mark.setIsApprive(BillCons.NO);
            this.markService.saveOrUpdate((Object)mark, false);
        }
        this.calculateMark(billId);
        return CommonResponse.success((String)"\u64a4\u56de\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SchemeApprovalEntity entity = (SchemeApprovalEntity)((Object)this.approvalService.selectById(billId));
        entity.setPassTime(new Date());
        this.approvalService.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SchemeApprovalEntity entity = (SchemeApprovalEntity)((Object)this.approvalService.selectById(billId));
        if (entity.getExpertArgumentState() == 1) {
            return CommonResponse.error((String)"\u5916\u90e8\u4e13\u5bb6\u5df2\u8bba\u8bc1\uff0c\u4e0d\u80fd\u5f03\u5ba1!");
        }
        if (entity.getChangeStatus() != 1) {
            return CommonResponse.error((String)"\u5355\u636e\u5df2\u53d8\u66f4\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(SchemeApprovalMarkEntity::getIsApprive, (Object)BillCons.NO);
        updateWrapper.eq(SchemeApprovalMarkEntity::getApprovalId, (Object)billId);
        this.markService.update((Wrapper)updateWrapper);
        LambdaUpdateWrapper updateWrapper2 = new LambdaUpdateWrapper();
        updateWrapper2.set(SchemeApprovalEntity::getAverageMark, null);
        updateWrapper2.set(SchemeApprovalEntity::getIsMark, (Object)BillCons.NO);
        updateWrapper2.eq(BaseEntity::getId, (Object)billId);
        this.approvalService.update((Wrapper)updateWrapper2);
        return CommonResponse.success((String)"\u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u6210\u529f\uff01");
    }
}

