/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scheme.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scheme.bean.SchemeApprovalEntity;
import com.ejianc.business.scheme.bean.SchemePlanDetailEntity;
import com.ejianc.business.scheme.cons.PlanCons;
import com.ejianc.business.scheme.mapper.SchemeApprovalMapper;
import com.ejianc.business.scheme.service.ISchemeApprovalService;
import com.ejianc.business.scheme.service.ISchemePlanDetailService;
import com.ejianc.business.scheme.vo.SchemeApprovalReportVO;
import com.ejianc.business.scheme.vo.SchemeApprovalVO;
import com.ejianc.business.scheme.vo.SqlParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="schemeApprovalService")
public class SchemeApprovalServiceImpl
extends BaseServiceImpl<SchemeApprovalMapper, SchemeApprovalEntity>
implements ISchemeApprovalService {
    private static final String BILL_CODE_ROLE = "SCHEME_APPROVAL_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISchemePlanDetailService planDetailService;

    @Override
    public CommonResponse<SchemeApprovalVO> saveOrUpdate(SchemeApprovalVO saveorUpdateVO) {
        SchemeApprovalEntity data = (SchemeApprovalEntity)((Object)super.getById((Serializable)saveorUpdateVO.getId()));
        SchemeApprovalEntity entity = (SchemeApprovalEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SchemeApprovalEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE_ROLE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        SchemePlanDetailEntity planDetail = (SchemePlanDetailEntity)((Object)this.planDetailService.getById(saveorUpdateVO.getSchemeId()));
        planDetail.setFinishState(PlanCons.YES);
        this.planDetailService.updateFinishState(planDetail);
        if (data != null && !saveorUpdateVO.getSchemeId().equals(data.getSchemeId())) {
            SchemePlanDetailEntity oldPlanDetail = (SchemePlanDetailEntity)((Object)this.planDetailService.getById(data.getSchemeId()));
            oldPlanDetail.setFinishState(PlanCons.NO);
            this.planDetailService.updateFinishState(oldPlanDetail);
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), SchemeApprovalVO.class));
    }

    @Override
    public CommonResponse<String> delete(List<SchemeApprovalVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List list = super.list((Wrapper)new QueryWrapper().in((Object)"id", ids));
        List schemeIds = list.stream().map(SchemeApprovalEntity::getSchemeId).collect(Collectors.toList());
        super.removeByIds(ids, true);
        for (Long schemeId : schemeIds) {
            SchemePlanDetailEntity planDetail = (SchemePlanDetailEntity)((Object)this.planDetailService.getById(schemeId));
            planDetail.setFinishState(PlanCons.NO);
            this.planDetailService.updateFinishState(planDetail);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public List<Map<String, Object>> queryArgumentDateDueWarn(List<SqlParam> sqlParamList) {
        return ((SchemeApprovalMapper)this.baseMapper).queryArgumentDateDueWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryArgumentDateOverWarn(List<SqlParam> sqlParamList) {
        return ((SchemeApprovalMapper)this.baseMapper).queryArgumentDateOverWarn(sqlParamList);
    }

    @Override
    public List<SchemeApprovalReportVO> queryReport(Page<SchemeApprovalReportVO> page, QueryWrapper wrapper) {
        return ((SchemeApprovalMapper)this.baseMapper).queryReport(page, wrapper);
    }
}

