/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scheme.service.impl;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.scheme.bean.SchemePlanChangeEntity;
import com.ejianc.business.scheme.bean.SchemePlanDetailChangeEntity;
import com.ejianc.business.scheme.bean.SchemePlanDetailEntity;
import com.ejianc.business.scheme.bean.SchemePlanEntity;
import com.ejianc.business.scheme.bean.SchemePlanHistoryEntity;
import com.ejianc.business.scheme.enums.ChangeStatusEnum;
import com.ejianc.business.scheme.service.ISchemePlanChangeService;
import com.ejianc.business.scheme.service.ISchemePlanDetailService;
import com.ejianc.business.scheme.service.ISchemePlanHistoryService;
import com.ejianc.business.scheme.service.ISchemePlanService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="schemePlanChange")
public class SchemePlanChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISchemePlanService planService;
    @Autowired
    private ISchemePlanDetailService planDetailService;
    @Autowired
    private ISchemePlanChangeService planChangeService;
    @Autowired
    private ISchemePlanHistoryService planHistoryService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private SessionManager sessionManager;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        SchemePlanChangeEntity entity = (SchemePlanChangeEntity)((Object)this.planChangeService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        this.planChangeService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u65bd\u5de5\u65b9\u6848\u8ba1\u5212\u53d8\u66f4\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        SchemePlanChangeEntity planChange = (SchemePlanChangeEntity)((Object)this.planChangeService.selectById(billId));
        SchemePlanEntity newPlanEntity = null;
        SchemePlanEntity oldPlan = (SchemePlanEntity)((Object)this.planService.selectById(planChange.getPlanId()));
        if (state == BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            UserContext userContext = this.sessionManager.getUserContext();
            planChange.setCommitDate(new Date());
            planChange.setCommitUserCode(userContext.getUserCode());
            planChange.setCommitUserName(userContext.getUserName());
        }
        planChange.setEffectiveDate(new Date());
        SchemePlanHistoryEntity recordEntity = (SchemePlanHistoryEntity)((Object)BeanMapper.map((Object)((Object)oldPlan), SchemePlanHistoryEntity.class));
        this.logger.info("\u65bd\u5de5\u65b9\u6848\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03, \u53d8\u66f4\u540e\u4fe1\u606f\uff1a\u3010{}\u3011, \u53d8\u66f4\u524d\u4fe1\u606f: \u3010{}\u3011", (Object)JSON.toJSONString((Object)((Object)planChange)), (Object)JSON.toJSONString((Object)((Object)oldPlan)));
        recordEntity.setPlanId(oldPlan.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getPlanDetail())) {
            recordEntity.getPlanDetail().stream().forEach(detail -> {
                detail.setDetailId(detail.getId());
                detail.setPlanId(recordEntity.getId());
                detail.setId(null);
            });
        }
        recordEntity.setCreateUserCode(planChange.getCreateUserCode());
        recordEntity.setCreateTime(planChange.getCreateTime());
        recordEntity.setCreateUserName(planChange.getCreateUserName());
        recordEntity.setModifyUserName(planChange.getModifyUserName());
        recordEntity.setUpdateTime(planChange.getUpdateTime());
        recordEntity.setUpdateUserCode(planChange.getUpdateUserCode());
        recordEntity.setCommitDate(planChange.getCommitDate());
        recordEntity.setCommitUserCode(planChange.getCommitUserCode());
        recordEntity.setCommitUserName(planChange.getCommitUserName());
        recordEntity.setEffectiveDate(planChange.getEffectiveDate());
        recordEntity.setChangeReason(planChange.getChangeReason());
        recordEntity.setEffectiveDate(new Date());
        this.planHistoryService.saveOrUpdate((Object)recordEntity, false);
        this.planChangeService.saveOrUpdate((Object)planChange, false);
        newPlanEntity = (SchemePlanEntity)((Object)BeanMapper.map((Object)((Object)planChange), SchemePlanEntity.class));
        newPlanEntity.setChangeState(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        newPlanEntity.setBillCode(oldPlan.getBillCode());
        newPlanEntity.setChangeId(null);
        newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
        newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
        newPlanEntity.setCreateTime(oldPlan.getCreateTime());
        newPlanEntity.setId(oldPlan.getId());
        newPlanEntity.setVersion(oldPlan.getVersion());
        newPlanEntity.setChangeVersion(planChange.getChangeVersion());
        Map<Long, Integer> map = oldPlan.getPlanDetail().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
        if (CollectionUtils.isNotEmpty(planChange.getPlanDetail())) {
            ArrayList<SchemePlanDetailEntity> list = new ArrayList<SchemePlanDetailEntity>();
            SchemePlanDetailEntity tmp = null;
            for (SchemePlanDetailChangeEntity detail2 : planChange.getPlanDetail()) {
                tmp = (SchemePlanDetailEntity)((Object)BeanMapper.map((Object)((Object)detail2), SchemePlanDetailEntity.class));
                Long detailId = detail2.getDetailId();
                if (null != detail2.getDetailId()) {
                    tmp.setId(detailId);
                    tmp.setVersion(map.get(detailId));
                    tmp.setRowState("update");
                    list.add(tmp);
                    map.remove(detailId);
                    continue;
                }
                tmp.setRowState("add");
                list.add(tmp);
            }
            newPlanEntity.setPlanDetail(list);
        }
        if (map.size() > 0) {
            map.keySet();
            this.planService.delByPlanIdAndDetailIds(new ArrayList<Long>(map.keySet()), oldPlan.getId());
        }
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT210324000000008", "planImg", String.valueOf(oldPlan.getId()), "BT210324000000007", "planImg");
        if (this.planService.saveOrUpdate((Object)newPlanEntity, false)) {
            return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

