package com.ejianc.business.scheme.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scheme.bean.SchemeApprovalEntity;
import com.ejianc.business.scheme.bean.SchemeApprovalMarkEntity;
import com.ejianc.business.scheme.bean.SchemePlanEntity;
import com.ejianc.business.scheme.service.ISchemeApprovalMarkService;
import com.ejianc.business.scheme.service.ISchemeApprovalService;
import com.ejianc.business.scheme.service.ISchemePlanService;
import com.ejianc.business.scheme.vo.SchemeApprovalMarkVO;
import com.ejianc.business.scheme.vo.SchemeApprovalReportVO;
import com.ejianc.business.scheme.vo.SchemeApprovalVO;
import com.ejianc.business.scheme.vo.SchemePlanRefVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 施工方案报批实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("schemeApproval")
public class SchemeApprovalController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;
    
    @Autowired
    private ISchemeApprovalService service;

    @Autowired
    private ISchemeApprovalMarkService markService;

    @Autowired
    private ISchemePlanService planService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SchemeApprovalVO> saveOrUpdate(@RequestBody SchemeApprovalVO saveorUpdateVO) {
        CommonResponse<SchemeApprovalVO> response = service.saveOrUpdate(saveorUpdateVO);
        return response;
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemeApprovalVO> queryDetail(Long id) {
    	SchemeApprovalEntity entity = service.selectById(id);
    	SchemeApprovalVO vo = BeanMapper.map(entity, SchemeApprovalVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SchemeApprovalVO> vos) {
        return service.delete(vos);
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SchemeApprovalVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("schemeName");
        fuzzyFields.add("schemeGradeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        
        IPage<SchemeApprovalEntity> page = service.queryPage(param,false);
        IPage<SchemeApprovalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SchemeApprovalVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 方案评审管理台账
     *
     * @Param param:
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.scheme.vo.SchemeApprovalVO>>
     * @Author songlx
     * @Date \
     **/
    @RequestMapping(value = "/markReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SchemeApprovalReportVO>> markReport(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("schemeName");
        fuzzyFields.add("schemeGradeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SchemeApprovalEntity> page = service.queryPage(param, false);
        IPage<SchemeApprovalReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SchemeApprovalVO> records = BeanMapper.mapList(page.getRecords(), SchemeApprovalVO.class);
        List<SchemeApprovalReportVO> newRecords = new ArrayList<>();
        if (!CollectionUtils.isEmpty(records)) {
            List<Long> pIds = records.stream().map(SchemeApprovalVO::getId).collect(Collectors.toList());
            QueryParam qryMap = new QueryParam();
            qryMap.getParams().put("approvalId", new Parameter(QueryParam.IN, pIds));
            List<SchemeApprovalMarkEntity> schemeApprovalMarkEntities = markService.queryList(qryMap);
            if (!CollectionUtils.isEmpty(schemeApprovalMarkEntities)) {
                List<SchemeApprovalMarkVO> schemeApprovalMarkVOS = BeanMapper.mapList(schemeApprovalMarkEntities, SchemeApprovalMarkVO.class);
                Map<Long, SchemeApprovalVO> beanMap = new HashMap<>();
                for (SchemeApprovalVO reportVO : records) {
                    beanMap.put(reportVO.getId(), reportVO);
                }
                for (SchemeApprovalMarkVO markVO : schemeApprovalMarkVOS) {
                    Long approvalId = markVO.getApprovalId();
                    SchemeApprovalReportVO newReportVO = BeanMapper.map(beanMap.get(approvalId), SchemeApprovalReportVO.class);
                    Long id = newReportVO.getId();
                    newReportVO.setId(markVO.getId());
                    newReportVO.setParentId(id);
                    newReportVO.setProcessInstanceId(markVO.getProcessInstanceId());
                    newReportVO.setAppriveIndex(markVO.getAppriveIndex());
                    newReportVO.setExpertId(markVO.getExpertId());
                    newReportVO.setExpertName(markVO.getExpertName());
                    newReportVO.setAppriveStartTime(markVO.getAppriveStartTime());
                    newReportVO.setAppriveEndTime(markVO.getAppriveEndTime());
                    newReportVO.setExpertOpion(markVO.getExpertOpion());
                    newReportVO.setMark(markVO.getMark());
                    newReportVO.setIsApprive(markVO.getIsApprive());
                    newRecords.add(newReportVO);
                }

            }

        }
        pageData.setRecords(newRecords);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @RequestMapping(value = "/queryReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SchemeApprovalReportVO>> queryReport(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("schemeName");
        fuzzyFields.add("schemeGradeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        Page<SchemeApprovalReportVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<SchemeApprovalReportVO> list = service.queryReport(page, wrapper);
        if(!CollectionUtils.isEmpty(list)){
            list.stream().forEach(t->{
                t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription());
            });
        }
        IPage<SchemeApprovalReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * 管理台账 报表
     * @Param param:
     * @Param response:
     * @Return void
     * @Author songlx
     * @Date 2021-03-30
     **/
    @RequestMapping(value = "/excelManageReport", method = RequestMethod.POST)
    @ResponseBody
    public void queryReport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        CommonResponse<IPage<SchemeApprovalReportVO>> res = this.queryReport(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", res.getData().getRecords());
        ExcelExport.getInstance().export("scheme-manage-report.xlsx", beans, response);


    }


    /**
     * @Description schemeDynamicReport 查询施工方案动态台账
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/schemeDynamicReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SchemeApprovalReportVO>> schemeDynamicReport(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
//        fuzzyFields.add("billCode");
        fuzzyFields.add("schemeName");
        fuzzyFields.add("schemeGradeName");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("engineeringTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id",new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SchemeApprovalEntity> page = service.queryPage(param,false);
        IPage<SchemeApprovalReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SchemeApprovalReportVO> records = BeanMapper.mapList(page.getRecords(), SchemeApprovalReportVO.class);
        if(!CollectionUtils.isEmpty(records)){
            for(SchemeApprovalReportVO vo : records){
                Period p = this.calculateTimeDifferenceByPeriod(vo.getCreateDate(), vo.getPlanCreateDate());
                vo.setDay(p.getDays());
                SchemePlanEntity plan = planService.selectById(vo.getSchemePlanId());
                vo.setEffectiveDate(plan != null ? plan.getEffectiveDate() : null);
            }
        }
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 使用java 8的Period的对象计算两个LocalDate对象的时间差，严格按照年、月、日计算，如：2018-03-12 与 2014-05-23 相差 3 年 9 个月 17 天
     * @param date1
     * @param date2
     */
    public static Period calculateTimeDifferenceByPeriod(Date date1, Date date2) {
        // atZone()方法返回在指定时区从此Instant生成的ZonedDateTime。
        LocalDate localDate1 = date1.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Period p = Period.between(localDate1, localDate2);
        return p;
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        CommonResponse<IPage<SchemeApprovalVO>> res = this.queryList(param);
        List<SchemeApprovalVO> list = new ArrayList<>();
        if(res.isSuccess() && res.getData() != null && org.apache.commons.collections.CollectionUtils.isNotEmpty(res.getData().getRecords())){
            list = res.getData().getRecords();
            list.forEach(vo -> {
                String isExpertArgumentName = "";
                if(vo.getIsExpertArgument() != null && vo.getIsExpertArgument().equals("1")) {
                    isExpertArgumentName = "是";
                } else {
                    isExpertArgumentName = "否";
                }
                vo.setIsExpertArgumentName(isExpertArgumentName);
                String expertArgumentStateName = "";
                if(vo.getExpertArgumentState() != null && vo.getIsExpertArgument().equals("1")) {
                    expertArgumentStateName = "已论证";
                }
                vo.setExpertArgumentStateName(expertArgumentStateName);
                String changeVersionName = "";
                DecimalFormat df = new DecimalFormat("00");
                Integer changeVersion = vo.getChangeVersion() != null ? vo.getChangeVersion() + 1 : 1;
                changeVersionName = df.format(changeVersion);
                if(vo.getChangeStatus() == 2){
                    changeVersionName = "修订中-" + changeVersionName;
                }
                vo.setChangeVersionName(changeVersionName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("scheme-approval-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelDynamicReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelDynamicReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        CommonResponse<IPage<SchemeApprovalReportVO>> res = this.schemeDynamicReport(param);
        List<SchemeApprovalReportVO> list = new ArrayList<>();
        if(res.isSuccess() && res.getData() != null && org.apache.commons.collections.CollectionUtils.isNotEmpty(res.getData().getRecords())){
            list = res.getData().getRecords();
            list.forEach(vo -> {
                String isExpertArgumentName = "";
                if(vo.getIsExpertArgument() != null && vo.getIsExpertArgument().equals("1")) {
                    isExpertArgumentName = "是";
                } else {
                    isExpertArgumentName = "否";
                }
                vo.setIsExpertArgumentName(isExpertArgumentName);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("scheme-dynamic-report-export.xlsx", beans, response);
    }

}
