package com.ejianc.business.scheme.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scheme.bean.SchemeApprovalMarkEntity;
import com.ejianc.business.scheme.cons.BillCons;
import com.ejianc.business.scheme.service.ISchemeApprovalMarkService;
import com.ejianc.business.scheme.vo.SchemeApprovalMarkVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 施工方案报批评分实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("schemeApprovalMark")
public class SchemeApprovalMarkController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ISchemeApprovalMarkService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SchemeApprovalMarkVO> saveOrUpdate(@RequestBody SchemeApprovalMarkVO saveorUpdateVO) {
    	SchemeApprovalMarkEntity entity = BeanMapper.map(saveorUpdateVO, SchemeApprovalMarkEntity.class);
    	service.saveOrUpdate(entity, false);
    	SchemeApprovalMarkVO vo = BeanMapper.map(entity, SchemeApprovalMarkVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemeApprovalMarkVO> queryDetail(Long id) {
    	SchemeApprovalMarkEntity entity = service.selectById(id);
    	SchemeApprovalMarkVO vo = BeanMapper.map(entity, SchemeApprovalMarkVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SchemeApprovalMarkVO> vos) {
        service.removeByIds(vos.stream().map(SchemeApprovalMarkVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SchemeApprovalMarkVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        // 审批过的
//        param.getParams().put("isApprive", new Parameter(QueryParam.EQ, BillCons.YES));
        
        IPage<SchemeApprovalMarkEntity> page = service.queryPage(param,false);
        IPage<SchemeApprovalMarkVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SchemeApprovalMarkVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryDetail 查询详情
     * @param approvalId 施工方案报批主键
     * @param expertId 专家主键
     */
    @RequestMapping(value = "/queryMark", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemeApprovalMarkVO> queryMark(Long approvalId, Long expertId) {
        LambdaQueryWrapper<SchemeApprovalMarkEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SchemeApprovalMarkEntity::getApprovalId, approvalId);
        lambda.eq(SchemeApprovalMarkEntity::getExpertId, expertId);
        lambda.eq(SchemeApprovalMarkEntity::getIsApprive, 0);
        lambda.orderByAsc(SchemeApprovalMarkEntity::getCreateTime);
        List<SchemeApprovalMarkEntity> markList = service.list(lambda);
		if(CollectionUtils.isNotEmpty(markList)){
			SchemeApprovalMarkEntity entity = markList.get(0);
            SchemeApprovalMarkVO vo = BeanMapper.map(entity, SchemeApprovalMarkVO.class);
            return CommonResponse.success("查询详情数据成功！",vo);
        }
        return CommonResponse.success("查询详情数据成功！",null);
    }

}
