package com.ejianc.business.scheme.controller;

import java.io.Serializable;

import com.ejianc.business.scheme.bean.SchemeDocEntity;
import com.ejianc.business.scheme.service.ISchemeDocService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.scheme.bean.SchemeCategoryEntity;
import com.ejianc.business.scheme.service.ISchemeCategoryService;
import com.ejianc.business.scheme.vo.SchemeCategoryVO;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 施工方案档案
 *
 * @author generator
 */
@Controller
@RequestMapping("schemeCategory")
public class SchemeCategoryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISchemeCategoryService service;
    @Autowired
    private ISchemeDocService docService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SchemeCategoryVO> saveOrUpdate(@RequestBody SchemeCategoryVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemeCategoryVO> queryDetail(Long id) {
        SchemeCategoryEntity entity = service.selectById(id);
        SchemeCategoryVO vo = BeanMapper.map(entity, SchemeCategoryVO.class);
        if (entity.getParentId() != null && entity.getParentId() > 0) {
            SchemeCategoryEntity parentEntity = service.selectById(entity.getParentId());
            vo.setParentName(parentEntity.getName());
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        //有子节点不允许删除
        List<SchemeCategoryEntity> children = service.queryListByPid(id);
        if (children != null && children.size() > 0) {
            return CommonResponse.error("该分类下有子分类不允许删除");
        }
        //分类下有方案了不允许删除
        List<SchemeDocEntity> materialList = docService.queryListByCategoryId(id);
        if (materialList != null && materialList.size() > 0) {
            return CommonResponse.error("该分类下有方案了，不允许删除");
        }
        service.removeById(id);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询分类树
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("id", "asc");
        List<SchemeCategoryEntity> list = service.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * @param id
     * @Description getChildIds 查询本下主键
     */
    @RequestMapping(value = "/getChildIds", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Long>> getChildIds(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.getChildIds(id));
    }

    /**
     * @Description queryList 查询分类树参照
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/treeList", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> treeList(@RequestParam(value = "searchText", required = false) String searchText) {
        /** 租户隔离 */
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("id", "asc");
        List<SchemeCategoryEntity> list = service.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * 查询树参照，不包含本下
     *
     * @return
     */
    @RequestMapping(value = "/treeRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> treeRef(@RequestParam(value = "id", required = false) Long id) {
        return CommonResponse.success("查询详情数据成功！", service.treeRef(id));
    }

    /************* 导入导出start  *********/
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "scheme-category-import.xlsx", "施工方案档案分类导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request, response);
    }

    @RequestMapping(value = "/saveImportExcelCategory", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelCategory(@RequestBody List<SchemeCategoryVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<SchemeCategoryEntity> list = new ArrayList<>();
        importVOS.forEach(importVO -> list.add(BeanMapper.map(importVO, SchemeCategoryEntity.class)));
        service.insertBatch(list);
        return CommonResponse.success("保存成功！");
    }

    /************* 导入导出  end  *********/

}
