package com.ejianc.business.scheme.service.impl;

import com.ejianc.business.scheme.bean.SchemeApprovalChangeEntity;
import com.ejianc.business.scheme.bean.SchemeApprovalEntity;
import com.ejianc.business.scheme.bean.SchemeApprovalHistoryEntity;
import com.ejianc.business.scheme.cons.BillCons;
import com.ejianc.business.scheme.enums.ChangeStatusEnum;
import com.ejianc.business.scheme.service.ISchemeApprovalChangeService;
import com.ejianc.business.scheme.service.ISchemeApprovalHistoryService;
import com.ejianc.business.scheme.service.ISchemeApprovalService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("schemeApprovalChange") 
public class SchemeApprovalChangeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISchemeApprovalService approvalService;

	@Autowired
	private ISchemeApprovalChangeService changeService;

	@Autowired
	private ISchemeApprovalHistoryService historyService;

	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		// 变更表
		SchemeApprovalChangeEntity changeEntity = changeService.selectById(billId);
		// 主表
		SchemeApprovalEntity entity = approvalService.selectById(changeEntity.getSourceId());
		// 记录历史表
		SchemeApprovalHistoryEntity historyEntity = BeanMapper.map(entity, SchemeApprovalHistoryEntity.class);
		historyEntity.setSourceId(changeEntity.getSourceId());//原主表主键
		historyEntity.setId(null);
		historyService.saveOrUpdate(historyEntity, false);

		// 回写主表
		entity.setChangeStatus(ChangeStatusEnum.已变更.getCode());//状态改为已变更
		entity.setStartDate(changeEntity.getStartDate());// 项目开工日期
		entity.setEndDate(changeEntity.getEndDate());// 项目交工日期
		entity.setEngineerId(changeEntity.getEngineerId());// 项目总工
		entity.setEngineerName(changeEntity.getEngineerName());// 项目总工名称
		entity.setEngineerMobile(changeEntity.getEngineerMobile());// 项目总工电话
		entity.setCreateUnitType(changeEntity.getCreateUnitType());// 编制主体类型 1-内部单位 2-外部单位
		entity.setCreateUnitId(changeEntity.getCreateUnitId());// 编制主体
		entity.setCreateUnitName(changeEntity.getCreateUnitName());// 编制主体名称
		entity.setEmployeeId(changeEntity.getEmployeeId());// 编制人
		entity.setEmployeeName(changeEntity.getEmployeeName());// 编制人名称
		entity.setEmployeeMobile(changeEntity.getEmployeeMobile());// 编制人联系方式
		entity.setCreateDate(changeEntity.getCreateDate());// 编制日期
		entity.setCreateExplain(changeEntity.getCreateExplain());// 编制情况
		entity.setChangeReason(changeEntity.getChangeReason());// 变更原因

		entity.setChangeVersion(changeEntity.getChangeVersion());// 变更版本
		approvalService.saveOrUpdate(entity);

		changeEntity.setUsedTime(new Date());
		changeService.saveOrUpdate(changeEntity, false);

		CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
				String.valueOf(billId), BillCons.SOURCE_BILL_TYPE, BillCons.SOURCE_BILL_SOURCE_TYPE,
				String.valueOf(entity.getId()), BillCons.TARGET_BILL_TYPE, BillCons.TARGET_BILL_SOURCE_TYPE);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
