package com.ejianc.business.scheme.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.scheme.cons.PartCons;
import com.ejianc.business.scheme.utils.ExcelImportUtil;
import com.ejianc.business.scheme.utils.InnerCodeTool;
import com.ejianc.business.scheme.vo.SchemeCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scheme.mapper.SchemeCategoryMapper;
import com.ejianc.business.scheme.bean.SchemeCategoryEntity;
import com.ejianc.business.scheme.service.ISchemeCategoryService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工方案档案
 *
 * @author generator
 */
@Service("schemeCategoryService")
public class SchemeCategoryServiceImpl extends BaseServiceImpl<SchemeCategoryMapper, SchemeCategoryEntity> implements ISchemeCategoryService {

    @Override
    public CommonResponse<SchemeCategoryVO> saveOrUpdate(SchemeCategoryVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SchemeCategoryEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            SchemeCategoryEntity oldEntity = baseMapper.selectById(saveorUpdateVO.getId());
            entity = BeanMapper.map(oldEntity, SchemeCategoryEntity.class);
            entity.setCode(saveorUpdateVO.getCode());
            entity.setName(saveorUpdateVO.getName());
            entity.setParentId(saveorUpdateVO.getParentId());
            QueryParam param = new QueryParam();
            param.getParams().put("inner_code", new Parameter(QueryParam.LIKE, oldEntity.getInnerCode()));
            param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
            List<SchemeCategoryEntity> oldEntities = super.queryList(param);
            //原本没有父级，现在有
            if ((oldEntity.getParentId() == null || oldEntity.getParentId() <= 0)
                    && (entity.getParentId() != null && entity.getParentId() > 0)) {
                SchemeCategoryEntity parentEntity = baseMapper.selectById(entity.getParentId());
                for (SchemeCategoryEntity sce : oldEntities) {
                    if (sce.getId().equals(entity.getId())) {
                        sce.setParentId(entity.getParentId());
                        sce.setName(entity.getName());
                        sce.setCode(entity.getCode());
                    }
                    sce.setInnerCode(parentEntity.getInnerCode() + "," + sce.getInnerCode());
                }
                super.saveOrUpdateBatch(oldEntities);
                return CommonResponse.success("修改成功！");
            }
            //原本有父级，现在没有
            if ((entity.getParentId() == null || entity.getParentId() <= 0)
                    && (oldEntity.getParentId() != null && oldEntity.getParentId() > 0)) {
                for (SchemeCategoryEntity sce : oldEntities) {
                    if (sce.getId().equals(entity.getId())) {
                        sce.setParentId(entity.getParentId());
                        sce.setName(entity.getName());
                        sce.setCode(entity.getCode());
                    }
                    String a = oldEntity.getInnerCode();

                    String b = oldEntity.getId().toString();
                    String i = sce.getInnerCode();
                    String x = i.replaceAll(a, b);
                    String innerCode = sce.getInnerCode().replaceAll(oldEntity.getInnerCode(), oldEntity.getId().toString());
                    sce.setInnerCode(innerCode);
                }
                super.saveOrUpdateBatch(oldEntities);
                return CommonResponse.success("修改成功！");
            }
            //原本有父级，现在改变了
            if ((entity.getParentId() != null && entity.getParentId() > 0)
                    && (oldEntity.getParentId() != null && oldEntity.getParentId() > 0)
                    && entity.getParentId() != oldEntity.getParentId()) {
                SchemeCategoryEntity parentEntity = baseMapper.selectById(entity.getParentId());
                for (SchemeCategoryEntity sce : oldEntities) {
                    if (sce.getId().equals(entity.getId())) {
                        sce.setParentId(entity.getParentId());
                        sce.setName(entity.getName());
                        sce.setCode(entity.getCode());
                    }
                    String innerCode = sce.getInnerCode().replaceAll(oldEntity.getInnerCode(), parentEntity.getInnerCode() + "," + oldEntity.getId());
                    sce.setInnerCode(innerCode);
                }
                super.saveOrUpdateBatch(oldEntities);
                return CommonResponse.success("修改成功！");
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {//新增
            entity = BeanMapper.map(saveorUpdateVO, SchemeCategoryEntity.class);
            entity.setId(IdWorker.getId());
            if (StringUtils.isBlank(entity.getCode())) {
                entity.setCode(creatCode(entity.getParentId(), tenantId));
            } else {
                LambdaQueryWrapper<SchemeCategoryEntity> lambda = Wrappers.<SchemeCategoryEntity>lambdaQuery();
                lambda.eq(SchemeCategoryEntity::getTenantId, tenantId);
                lambda.eq(SchemeCategoryEntity::getCode, entity.getCode());
                lambda.eq(SchemeCategoryEntity::getDr, 0);
                List<SchemeCategoryEntity> entities = super.list(lambda);
                if (entities != null && entities.size() > 0) {
                    throw new BusinessException("存在相同编码，不允许保存!");
                }
            }
            if (entity.getParentId() != null && entity.getParentId() > 0) {
                SchemeCategoryEntity uniqueBean = baseMapper.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    @Override
    public List<SchemeCategoryEntity> queryListByPid(Long id) {
        SchemeCategoryEntity entity = baseMapper.selectById(id);
        QueryParam param = new QueryParam();
        param.getParams().put("inner_code", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
        param.getParams().put("id", new Parameter(QueryParam.NE, id));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<SchemeCategoryEntity> oldEntities = super.queryList(param);
        return oldEntities;
    }

    @Override
    public List<Long> getChildIds(Long id) {
        SchemeCategoryEntity entity = baseMapper.selectById(id);
        QueryParam param = new QueryParam();
        param.getParams().put("inner_code", new Parameter(QueryParam.LIKE, entity.getInnerCode()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<SchemeCategoryEntity> oldEntities = super.queryList(param);
        return oldEntities.stream().map(SchemeCategoryEntity::getId).collect(Collectors.toList());
    }

    /**
     * 生成编码
     *
     * @param pid
     * @param tenantid
     * @return
     */
    private String creatCode(Long pid, Long tenantid) {
        // 获取最大的code 暂不考虑并发问题、几率很小
        String pcode = "";
        if (pid != null && pid > 0) {
            pcode = getPcode(pid);
        }
        String getMaxCode = baseMapper.getMaxCode(tenantid, pcode, PartCons.CATEGORY_LENGTH);
        String nextValue = InnerCodeTool.getNextValue(getMaxCode, PartCons.CATEGORY_LENGTH);
        return pcode + nextValue;
    }

    @Override
    public String getPcode(Long id) {
        return baseMapper.getPcode(id);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("分类数据超过10000条，请分批上传！");
                }
                List<String> codeList = queryCodeByTenantId(tenantId);
                //筛选重复编码
                Map<String, Integer> indexMap = new HashMap<>();
                List<SchemeCategoryVO> detailVoList = new ArrayList<>();
                Map<String, Long> tidMap = new HashMap<>();// 编码对应的id
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    SchemeCategoryVO vo = new SchemeCategoryVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";
                    String parentCode = datas.get(0);
                    String code = datas.get(1);

                    if (StringUtils.isNotBlank(code)) {//编码不能为空
                        if (codeList.contains(parentCode)) {//判断和已有的是否重复
                            warnType = warnType + "编码已存在,";
                            flag = true;
                            parentWarn = true;
                        } else {
                            if (indexMap.containsKey(code)) {//是否和本excel重复
                                return CommonResponse.error("类别编码：第" + (indexMap.get(code) + 2) + "行和第" + (i + 2) + "行重复！");
                            } else {
                                indexMap.put(code, i);
                            }
                        }
                        if (tidMap.containsKey(code)) {
                            vo.setId(tidMap.get(code));
                        } else {
                            vo.setId(IdWorker.getId());
                        }
                        tidMap.put(code, vo.getId());
                        vo.setCode(code);
                    } else {
                        vo.setCode(null);
                        warnType = warnType + "编码为空,";
                        flag = true;
                        parentWarn = true;
                    }

                    //维护父子关系
                    if (StringUtils.isNotBlank(parentCode)) {
                        if (codeList.contains(parentCode)) {
                            warnType = warnType + "上级编码已存在,";
                            flag = true;
                            parentWarn = true;
                        }
                        if (tidMap.containsKey(parentCode)) {
                            vo.setParentId(tidMap.get(parentCode));
                        } else {
                            vo.setParentId(IdWorker.getId());
                            tidMap.put(parentCode, vo.getParentId());
                        }
                        vo.setParentCode(parentCode);
                    }

                    if (StringUtils.isBlank(datas.get(2))) {//清单名称为空
                        vo.setName(null);
                        warnType = warnType + "名称为空,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        vo.setName(datas.get(2));
                    }

                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    vo.setParentWarn(parentWarn);
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                    }
                    vo.setDescription(warnType);
                    vo.setTenantId(tenantId);
                    detailVoList.add(vo);
                }
                List<Map<String, Object>> deailTreeData = ResultAsTree.createTreeData(BeanMapper.mapList(detailVoList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> successList = ExcelImportUtil.treeToList(allList.get(0));
                List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
                resp.put("successList", creatInnerCode(successList));
                resp.put("errorList", errorList);
                resp.put("successNum", result.size() - errorList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public List<Map<String, Object>> treeRef(Long id) {
        /** 租户隔离 */
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (id != null && id > 0) {
            SchemeCategoryEntity schemeCategoryEntity = super.selectById(id);
            param.getParams().put("innerCode", new Parameter(QueryParam.NOT_LIKE, schemeCategoryEntity.getInnerCode()));
        }
        param.getOrderMap().put("id", "asc");
        List<SchemeCategoryEntity> list = super.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        return ResultAsTree.createTreeData(resultMapList);
    }

    @Override
    public void insertBatch(List<SchemeCategoryEntity> list) {
        if(ListUtil.isNotEmpty(list)){
            super.saveBatch(list);
        }
    }

    private List<String> queryCodeByTenantId(Long tenantId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<SchemeCategoryEntity> schemeCategoryEntities = super.queryList(param);
        List<String> codeList = schemeCategoryEntities.stream().map(SchemeCategoryEntity::getCode).collect(Collectors.toList());
        return codeList;
    }

    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> successList) {
        List<String> enList = new ArrayList<>();
        for (Map<String, Object> map : successList) {
            enList.add(map.get("id").toString());
        }
        for (Map<String, Object> map : successList) {
            if (map.get("parentId") != null) {
                if (!enList.contains(map.get("parentId").toString())) {
                    map.put("parentId", null);
                }
            }
        }
        for (Map<String, Object> map : successList) {
            String innerCode = getInnerCode(successList, map.get("id").toString());
            map.put("innerCode", innerCode);
        }
        return successList;
    }

    private String getInnerCode(List<Map<String, Object>> successList, String id) {
        for (Map<String, Object> map : successList) {
            if (map.get("id").toString().equals(id)) {
                if (map.get("parentId") != null) {
                    String parentInnerCode = getInnerCode(successList, map.get("parentId").toString());
                    if (StringUtils.isNotBlank(parentInnerCode)) {
                        return parentInnerCode + "," + map.get("id").toString();
                    } else {
                        return map.get("id").toString();
                    }
                } else {
                    return map.get("id").toString();
                }
            }
        }
        return "";
    }

}
