package com.ejianc.business.scheme.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.scheme.bean.SchemeCategoryEntity;
import com.ejianc.business.scheme.cons.PartCons;
import com.ejianc.business.scheme.service.ISchemeCategoryService;
import com.ejianc.business.scheme.utils.ExcelImportUtil;
import com.ejianc.business.scheme.utils.InnerCodeTool;
import com.ejianc.business.scheme.vo.SchemeDocVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scheme.mapper.SchemeDocMapper;
import com.ejianc.business.scheme.bean.SchemeDocEntity;
import com.ejianc.business.scheme.service.ISchemeDocService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 施工方案
 *
 * @author generator
 */
@Service("schemeDocService")
public class SchemeDocServiceImpl extends BaseServiceImpl<SchemeDocMapper, SchemeDocEntity> implements ISchemeDocService {
    private static final String DEF_DOC_TYPE_CODE = "scheme_grade";

    @Autowired
    private ISchemeCategoryService categoryService;
    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public List<SchemeDocEntity> queryListByCategoryId(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("category_id", new Parameter(QueryParam.LIKE, id));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<SchemeDocEntity> oldEntities = super.queryList(param);
        return oldEntities;
    }

    @Override
    public CommonResponse<SchemeDocVO> saveOrUpdate(SchemeDocVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(saveorUpdateVO.getCategoryId() == null || saveorUpdateVO.getCategoryId() <= 0){
            throw new BusinessException("请先选择方案分类!");
        }
        SchemeDocEntity entity = BeanMapper.map(saveorUpdateVO, SchemeDocEntity.class);
        SchemeCategoryEntity schemeCategoryEntity = categoryService.selectById(entity.getCategoryId());
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity.setTenantId(tenantId);
            entity.setCategoryName(schemeCategoryEntity.getName());
            super.saveOrUpdate(entity, false);
            SchemeDocVO vo = BeanMapper.map(entity, SchemeDocVO.class);
            return CommonResponse.success("保存或修改单据成功！", vo);
        } else {//新增
            if (StringUtils.isBlank(entity.getSchemeCode())) {
                entity.setSchemeCode(creatCode(entity.getCategoryId(), tenantId));
            } else {
                LambdaQueryWrapper<SchemeDocEntity> lambda = Wrappers.<SchemeDocEntity>lambdaQuery();
                lambda.eq(SchemeDocEntity::getTenantId, tenantId);
                lambda.eq(SchemeDocEntity::getSchemeCode, entity.getSchemeCode());
                lambda.eq(SchemeDocEntity::getDr, 0);
                List<SchemeDocEntity> entities = super.list(lambda);
                if (entities != null && entities.size() > 0) {
                    throw new BusinessException("存在相同编码，不允许保存!");
                }
            }
            entity.setCategoryName(schemeCategoryEntity.getName());
            super.saveOrUpdate(entity, false);
            SchemeDocVO vo = BeanMapper.map(entity, SchemeDocVO.class);
            return CommonResponse.success("保存或修改单据成功！", vo);
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if(result.size() > 10000) {
                    return CommonResponse.error("分类数据超过10000条，请分批上传！");
                }
                Map<String, SchemeCategoryEntity> categoryCodeMap = queryCategoryCode(tenantId);
                Map<String, Long> docMap = queryDefDoc();
                List<String> codeList = queryCodeByTenantId(tenantId);
                //筛选重复编码
                Map<String, Integer> indexMap = new HashMap<>();
                List<SchemeDocVO> errorList = new ArrayList<>();
                List<SchemeDocVO> successList = new ArrayList<>();
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    SchemeDocVO vo = new SchemeDocVO();
                    vo.setId(IdWorker.getId());
                    boolean flag = false;
                    String warnType = "";
                    String categoryCode = datas.get(0);
                    String schemeCode = datas.get(1);
                    String schemeName = datas.get(2);
                    String schemeGradeName = datas.get(3);
                    String schemeParameter = datas.get(4);

                    //分类编码
                    vo.setCategoryCode(categoryCode);
                    if (StringUtils.isNotBlank(categoryCode)) {//分类编码不为空
                        if (!categoryCodeMap.containsKey(categoryCode)) {
                            warnType = warnType + "分类编码不存在,";
                            flag = true;
                        } else {
                            SchemeCategoryEntity sce = categoryCodeMap.get(categoryCode);
                            vo.setCategoryId(sce.getId());
                            vo.setCategoryName(sce.getName());
                        }
                    } else {
                        vo.setCategoryId(null);
                        vo.setCategoryName(null);
                        warnType = warnType + "分类编码为空,";
                        flag = true;
                    }

                    if (StringUtils.isNotBlank(schemeCode)) {//编码不能为空
                        if (codeList.contains(schemeCode)) {//判断和已有的是否重复
                            warnType = warnType + "编码已存在,";
                            flag = true;
                        } else {
                            if (indexMap.containsKey(schemeCode)) {//是否和本excel重复
                                return CommonResponse.error("方案编码：第" + (indexMap.get(schemeCode) + 2) + "行和第" + (i + 2) + "行重复！");
                            } else {
                                indexMap.put(schemeCode, i);
                            }
                        }
                        vo.setSchemeCode(schemeCode);
                    } else {
                        vo.setSchemeCode(null);
                        warnType = warnType + "编码为空,";
                        flag = true;
                    }

                    if (StringUtils.isBlank(schemeName)) {//名称为空
                        vo.setSchemeName(null);
                        warnType = warnType + "方案名称为空,";
                        flag = true;
                    } else {
                        vo.setSchemeName(schemeName);
                    }

                    if (StringUtils.isBlank(schemeGradeName)) {
                        vo.setSchemeGrade(null);
                        vo.setSchemeGradeName(null);
                        warnType = warnType + "方案分级为空,";
                        flag = true;
                    } else {
                        if (docMap.containsKey(schemeGradeName)) {
                            vo.setSchemeGrade(docMap.get(schemeGradeName));
                            vo.setSchemeGradeName(schemeGradeName);
                        } else {
                            vo.setSchemeGrade(null);
                            vo.setSchemeGradeName(null);
                            warnType = warnType + "方案分级不存在,";
                            flag = true;
                        }
                    }

                    if (StringUtils.isBlank(schemeParameter)) {
                        vo.setSchemeParameter(null);
                        warnType = warnType + "方案参数为空,";
                        flag = true;
                    } else {
                        vo.setSchemeParameter(schemeParameter);
                    }
                    vo.setTenantId(tenantId);
                    if (flag) {
                        warnType = warnType.substring(0, warnType.length() - 1);
                        vo.setDescription(warnType);
                        errorList.add(vo);
                    } else {
                        successList.add(vo);
                    }
                }
                resp.put("successList", successList);
                resp.put("errorList", errorList);
                resp.put("successNum", successList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public void insertBatch(List<SchemeDocEntity> list) {
        if(ListUtil.isNotEmpty(list)){
            super.saveBatch(list);
        }
    }

    private Map<String, Long> queryDefDoc() {
        CommonResponse<List<Map<String, Object>>> listCommonResponse = defdocApi.queryDetailListByDefdocCode(DEF_DOC_TYPE_CODE, null);
        if (listCommonResponse.isSuccess()) {
            List<Map<String, Object>> data = listCommonResponse.getData();
            Map<String,Long> docMap=new HashMap<>();
            for(Map<String, Object> map:data){
                docMap.put(map.get("name").toString(),Long.parseLong(map.get("id").toString()));
            }
            return docMap;
        } else {
            throw new BusinessException("查询方案分级失败!");
        }
    }

    // 查询所有编码
    private List<String> queryCodeByTenantId(Long tenantId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<SchemeDocEntity> schemeCategoryEntities = super.queryList(param);
        List<String> codeList = schemeCategoryEntities.stream().map(SchemeDocEntity::getSchemeCode).collect(Collectors.toList());
        return codeList;
    }

    /**
     * 生成编码
     *
     * @param tenantid
     * @return
     */
    private String creatCode(Long pid, Long tenantid) {
        String pcode = categoryService.getPcode(pid);
        String getMaxCode = baseMapper.getMaxCode(pcode, tenantid, PartCons.DOC_LENGTH);
        String nextValue = InnerCodeTool.getNextValue(getMaxCode, PartCons.DOC_LENGTH);
        return pcode + nextValue;
    }

    // 查所属分类编码
    private Map<String, SchemeCategoryEntity> queryCategoryCode(Long tenantId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<SchemeCategoryEntity> schemeCategoryEntities = categoryService.queryList(param);
        Map<String, SchemeCategoryEntity> codeMap = new HashMap<>();
        for (SchemeCategoryEntity sce : schemeCategoryEntities) {
            codeMap.put(sce.getCode(), sce);
        }
        return codeMap;
    }
}
