package com.ejianc.business.scheme.service.impl;

import com.ejianc.business.scheme.bean.SchemePlanDetailEntity;
import com.ejianc.business.scheme.bean.SchemePlanEntity;
import com.ejianc.business.scheme.cons.PlanCons;
import com.ejianc.business.scheme.enums.ChangeStatusEnum;
import com.ejianc.business.scheme.service.ISchemePlanDetailService;
import com.ejianc.business.scheme.service.ISchemePlanService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("schemePlan")
public class SchemePlanBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private ISchemePlanService planService;

    @Autowired
    private ISchemePlanDetailService planDetailService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private SessionManager sessionManager;


    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //此处billId即为单据Id
        SchemePlanEntity entity = planService.selectById(billId);
        UserContext userContext = sessionManager.getUserContext();
        //设置提交人信息
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        entity.setEffectiveDate(new Date());
        planService.saveOrUpdate(entity, false);

        return CommonResponse.success("施工方案计划提交回调成功！");
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //此处billId即为单据Id
        SchemePlanEntity entity = planService.selectById(billId);
        UserContext userContext = sessionManager.getUserContext();
        //设置提交人信息
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        entity.setEffectiveDate(new Date());
        planService.saveOrUpdate(entity, false);

        return CommonResponse.success("施工方案计划提交审批回调成功！");
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SchemePlanEntity entity = planService.selectById(billId);

        if (entity.getChangeState() != ChangeStatusEnum.未变更.getCode()) {
            return CommonResponse.error("单据已变更，无法弃审！");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("pId", new Parameter(QueryParam.EQ, billId));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        List<SchemePlanDetailEntity> schemePlanDetailEntities = planDetailService.queryList(param);
        for(SchemePlanDetailEntity detailEntity : schemePlanDetailEntities){
            if(detailEntity.getFinishState() == PlanCons.YES){
                return CommonResponse.error("单据下方案已编制，无法弃审！");
            }
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
