package com.ejianc.business.scheme.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.scheme.bean.SchemePlanChangeEntity;
import com.ejianc.business.scheme.bean.SchemePlanDetailChangeEntity;
import com.ejianc.business.scheme.bean.SchemePlanEntity;
import com.ejianc.business.scheme.bean.SchemePlanHistoryEntity;
import com.ejianc.business.scheme.enums.ChangeStatusEnum;
import com.ejianc.business.scheme.mapper.SchemePlanChangeMapper;
import com.ejianc.business.scheme.mapper.SchemePlanDetailChangeMapper;
import com.ejianc.business.scheme.mapper.SchemePlanHistoryMapper;
import com.ejianc.business.scheme.service.ISchemePlanChangeService;
import com.ejianc.business.scheme.service.ISchemePlanDetailChangeService;
import com.ejianc.business.scheme.service.ISchemePlanDetailHistoryService;
import com.ejianc.business.scheme.service.ISchemePlanService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 施工方案计划修订实体
 *
 * @author generator
 */
@Service("schemePlanChangeService")
public class SchemePlanChangeServiceImpl extends BaseServiceImpl<SchemePlanChangeMapper, SchemePlanChangeEntity> implements ISchemePlanChangeService {


    @Autowired
    private ISchemePlanService schemePlanService;

    @Autowired
    private ISchemePlanDetailChangeService schemePlanDetailChangeService;

    @Autowired
    private SchemePlanDetailChangeMapper changeMapper;

    @Autowired
    private ISchemePlanDetailHistoryService schemePlanDetailHistoryService;


    @Autowired
    private SchemePlanHistoryMapper planHisMapper;

    /**
     * 修订保存或者修改
     *
     * @Param saveOrUpdateVO: saveOrUpdateVO
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.scheme.vo.SchemePlanChangeVO>
     * @Author songlx
     * @Date 2021-03-25
     */
    @Override
    public SchemePlanChangeEntity saveOrUpdatePlan(SchemePlanChangeEntity saveEntity) {
        if (CollectionUtils.isNotEmpty(saveEntity.getPlanDetail())) {
            //更新子表信息
            if (null != saveEntity.getId()) {
                changeMapper.delByPId(saveEntity.getId());
            }
        }
        List<SchemePlanDetailChangeEntity> planDetail = saveEntity.getPlanDetail();
        Integer count = 0;
        if(CollectionUtils.isNotEmpty(planDetail)){
            for(SchemePlanDetailChangeEntity p : planDetail){
                String rowState = p.getRowState();
                if (!"del".equals(rowState)) {
                    count ++;
                }
            }
        }
        saveEntity.setPlanCount(count);
        super.saveOrUpdate(saveEntity, false);

        SchemePlanEntity planEntity = schemePlanService.selectById(saveEntity.getPlanId());
        if (ChangeStatusEnum.变更中.getCode() != planEntity.getChangeState()) {
            planEntity.setChangeState(ChangeStatusEnum.变更中.getCode());
            planEntity.setChangeId(saveEntity.getId());
            planEntity.setChangeCode(saveEntity.getBillCode());
            schemePlanService.saveOrUpdate(planEntity, false);
        }
        return saveEntity;
    }

    @Override
    public void deleteChangePlan(List<Long> changeIds) {
        List<SchemePlanChangeEntity> changeList = baseMapper.selectBatchIds(changeIds);
        List<Long> planIds = changeList.stream().map(SchemePlanChangeEntity::getPlanId).collect(Collectors.toList());

        QueryWrapper<SchemePlanEntity> planQuery = new QueryWrapper<>();
        planQuery.in("id", planIds);
        List<SchemePlanEntity> planList = schemePlanService.list(planQuery);

        //查询已有的变更历史记录
        // 若有值有的话把原计划修改状态改为已变更,若无值则改为未变更
        QueryWrapper<SchemePlanHistoryEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, plan_id as planId");
        query.in("plan_id", planIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("plan_id");
        List<Map<String, Object>> queryResult = planHisMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> {
            hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString()));
        });

        for (SchemePlanEntity plan : planList) {
            plan.setChangeState((null != hisCountNumMap.get(plan.getId()) && hisCountNumMap.get(plan.getId()) > 0) ? ChangeStatusEnum.已变更.getCode() : ChangeStatusEnum.未变更.getCode()); //未变更
            plan.setChangeId(null);
        }

        schemePlanService.saveOrUpdateBatch(planList, planList.size());

        super.removeByIds(changeList.stream().map(SchemePlanChangeEntity::getId).collect(Collectors.toList()), false);
    }


}
