/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scheme.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.scheme.bean.SchemeCategoryEntity;
import com.ejianc.business.scheme.mapper.SchemeCategoryMapper;
import com.ejianc.business.scheme.service.ISchemeCategoryService;
import com.ejianc.business.scheme.utils.ExcelImportUtil;
import com.ejianc.business.scheme.utils.InnerCodeTool;
import com.ejianc.business.scheme.vo.SchemeCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="schemeCategoryService")
public class SchemeCategoryServiceImpl
extends BaseServiceImpl<SchemeCategoryMapper, SchemeCategoryEntity>
implements ISchemeCategoryService {
    @Override
    public CommonResponse<SchemeCategoryVO> saveOrUpdate(SchemeCategoryVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SchemeCategoryEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            SchemeCategoryEntity oldEntity = (SchemeCategoryEntity)((Object)((SchemeCategoryMapper)this.baseMapper).selectById(saveorUpdateVO.getId()));
            entity = (SchemeCategoryEntity)((Object)BeanMapper.map((Object)((Object)oldEntity), SchemeCategoryEntity.class));
            entity.setCode(saveorUpdateVO.getCode());
            entity.setName(saveorUpdateVO.getName());
            entity.setParentId(saveorUpdateVO.getParentId());
            QueryParam param = new QueryParam();
            param.getParams().put("inner_code", new Parameter("like", (Object)oldEntity.getInnerCode()));
            param.getParams().put("dr", new Parameter("eq", (Object)0));
            List oldEntities = super.queryList(param);
            if ((oldEntity.getParentId() == null || oldEntity.getParentId() <= 0L) && entity.getParentId() != null && entity.getParentId() > 0L) {
                SchemeCategoryEntity parentEntity = (SchemeCategoryEntity)((Object)((SchemeCategoryMapper)this.baseMapper).selectById(entity.getParentId()));
                for (SchemeCategoryEntity sce : oldEntities) {
                    if (sce.getId().equals(entity.getId())) {
                        sce.setParentId(entity.getParentId());
                        sce.setName(entity.getName());
                        sce.setCode(entity.getCode());
                    }
                    sce.setInnerCode(parentEntity.getInnerCode() + "," + sce.getInnerCode());
                }
                super.saveOrUpdateBatch((Collection)oldEntities);
                return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
            }
            if ((entity.getParentId() == null || entity.getParentId() <= 0L) && oldEntity.getParentId() != null && oldEntity.getParentId() > 0L) {
                for (SchemeCategoryEntity sce : oldEntities) {
                    if (sce.getId().equals(entity.getId())) {
                        sce.setParentId(entity.getParentId());
                        sce.setName(entity.getName());
                        sce.setCode(entity.getCode());
                    }
                    String a = oldEntity.getInnerCode();
                    String b = oldEntity.getId().toString();
                    String i = sce.getInnerCode();
                    String x = i.replaceAll(a, b);
                    String innerCode = sce.getInnerCode().replaceAll(oldEntity.getInnerCode(), oldEntity.getId().toString());
                    sce.setInnerCode(innerCode);
                }
                super.saveOrUpdateBatch((Collection)oldEntities);
                return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
            }
            if (entity.getParentId() != null && entity.getParentId() > 0L && oldEntity.getParentId() != null && oldEntity.getParentId() > 0L && entity.getParentId() != oldEntity.getParentId()) {
                SchemeCategoryEntity parentEntity = (SchemeCategoryEntity)((Object)((SchemeCategoryMapper)this.baseMapper).selectById(entity.getParentId()));
                for (SchemeCategoryEntity sce : oldEntities) {
                    if (sce.getId().equals(entity.getId())) {
                        sce.setParentId(entity.getParentId());
                        sce.setName(entity.getName());
                        sce.setCode(entity.getCode());
                    }
                    String innerCode = sce.getInnerCode().replaceAll(oldEntity.getInnerCode(), parentEntity.getInnerCode() + "," + oldEntity.getId());
                    sce.setInnerCode(innerCode);
                }
                super.saveOrUpdateBatch((Collection)oldEntities);
                return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
            }
            super.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        entity = (SchemeCategoryEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SchemeCategoryEntity.class));
        entity.setId(IdWorker.getId());
        if (StringUtils.isBlank((String)entity.getCode())) {
            entity.setCode(this.creatCode(entity.getParentId(), tenantId));
        } else {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(SchemeCategoryEntity::getCode, (Object)entity.getCode());
            lambda.eq(BaseEntity::getDr, (Object)0);
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            SchemeCategoryEntity uniqueBean = (SchemeCategoryEntity)((Object)((SchemeCategoryMapper)this.baseMapper).selectById(entity.getParentId()));
            entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @Override
    public List<SchemeCategoryEntity> queryListByPid(Long id) {
        SchemeCategoryEntity entity = (SchemeCategoryEntity)((Object)((SchemeCategoryMapper)this.baseMapper).selectById(id));
        QueryParam param = new QueryParam();
        param.getParams().put("inner_code", new Parameter("like", (Object)entity.getInnerCode()));
        param.getParams().put("id", new Parameter("ne", (Object)id));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List oldEntities = super.queryList(param);
        return oldEntities;
    }

    @Override
    public List<Long> getChildIds(Long id) {
        SchemeCategoryEntity entity = (SchemeCategoryEntity)((Object)((SchemeCategoryMapper)this.baseMapper).selectById(id));
        QueryParam param = new QueryParam();
        param.getParams().put("inner_code", new Parameter("like", (Object)entity.getInnerCode()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List oldEntities = super.queryList(param);
        return oldEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
    }

    private String creatCode(Long pid, Long tenantid) {
        String pcode = "";
        if (pid != null && pid > 0L) {
            pcode = this.getPcode(pid);
        }
        String getMaxCode = ((SchemeCategoryMapper)this.baseMapper).getMaxCode(tenantid, pcode, 3);
        String nextValue = InnerCodeTool.getNextValue((String)getMaxCode, (int)3);
        return pcode + nextValue;
    }

    @Override
    public String getPcode(Long id) {
        return ((SchemeCategoryMapper)this.baseMapper).getPcode(id);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            List<String> codeList = this.queryCodeByTenantId(tenantId);
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<SchemeCategoryVO> detailVoList = new ArrayList<SchemeCategoryVO>();
            HashMap<String, Long> tidMap = new HashMap<String, Long>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                SchemeCategoryVO vo = new SchemeCategoryVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String parentCode = (String)datas.get(0);
                String code = (String)datas.get(1);
                if (StringUtils.isNotBlank((String)code)) {
                    if (codeList.contains(parentCode)) {
                        warnType = warnType + "\u7f16\u7801\u5df2\u5b58\u5728,";
                        flag = true;
                        parentWarn = true;
                    } else {
                        if (indexMap.containsKey(code)) {
                            return CommonResponse.error((String)("\u7c7b\u522b\u7f16\u7801\uff1a\u7b2c" + ((Integer)indexMap.get(code) + 2) + "\u884c\u548c\u7b2c" + (i + 2) + "\u884c\u91cd\u590d\uff01"));
                        }
                        indexMap.put(code, i);
                    }
                    if (tidMap.containsKey(code)) {
                        vo.setId((Long)tidMap.get(code));
                    } else {
                        vo.setId(Long.valueOf(IdWorker.getId()));
                    }
                    tidMap.put(code, vo.getId());
                    vo.setCode(code);
                } else {
                    vo.setCode(null);
                    warnType = warnType + "\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                }
                if (StringUtils.isNotBlank((String)parentCode)) {
                    if (codeList.contains(parentCode)) {
                        warnType = warnType + "\u4e0a\u7ea7\u7f16\u7801\u5df2\u5b58\u5728,";
                        flag = true;
                        parentWarn = true;
                    }
                    if (tidMap.containsKey(parentCode)) {
                        vo.setParentId((Long)tidMap.get(parentCode));
                    } else {
                        vo.setParentId(Long.valueOf(IdWorker.getId()));
                        tidMap.put(parentCode, vo.getParentId());
                    }
                    vo.setParentCode(parentCode);
                }
                if (StringUtils.isBlank((String)((String)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName((String)datas.get(2));
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setDescription(warnType);
                vo.setTenantId(tenantId);
                detailVoList.add(vo);
            }
            List deailTreeData = ResultAsTree.createTreeData((List)BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> successList = ExcelImportUtil.treeToList(allList.get(0));
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", this.creatInnerCode(successList));
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public List<Map<String, Object>> treeRef(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (id != null && id > 0L) {
            SchemeCategoryEntity schemeCategoryEntity = (SchemeCategoryEntity)((Object)super.selectById((Serializable)id));
            param.getParams().put("innerCode", new Parameter("not_like", (Object)schemeCategoryEntity.getInnerCode()));
        }
        param.getOrderMap().put("id", "asc");
        List list = super.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
        return ResultAsTree.createTreeData((List)resultMapList);
    }

    @Override
    public void insertBatch(List<SchemeCategoryEntity> list) {
        if (ListUtil.isNotEmpty(list)) {
            super.saveBatch(list);
        }
    }

    private List<String> queryCodeByTenantId(Long tenantId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List schemeCategoryEntities = super.queryList(param);
        List<String> codeList = schemeCategoryEntities.stream().map(SchemeCategoryEntity::getCode).collect(Collectors.toList());
        return codeList;
    }

    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> successList) {
        ArrayList<String> enList = new ArrayList<String>();
        for (Map<String, Object> map : successList) {
            enList.add(map.get("id").toString());
        }
        for (Map<String, Object> map : successList) {
            if (map.get("parentId") == null || enList.contains(map.get("parentId").toString())) continue;
            map.put("parentId", null);
        }
        for (Map<String, Object> map : successList) {
            String innerCode = this.getInnerCode(successList, map.get("id").toString());
            map.put("innerCode", innerCode);
        }
        return successList;
    }

    private String getInnerCode(List<Map<String, Object>> successList, String id) {
        for (Map<String, Object> map : successList) {
            if (!map.get("id").toString().equals(id)) continue;
            if (map.get("parentId") != null) {
                String parentInnerCode = this.getInnerCode(successList, map.get("parentId").toString());
                if (StringUtils.isNotBlank((String)parentInnerCode)) {
                    return parentInnerCode + "," + map.get("id").toString();
                }
                return map.get("id").toString();
            }
            return map.get("id").toString();
        }
        return "";
    }
}

