/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scheme.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.scheme.service.ISchemeApprovalService;
import com.ejianc.business.scheme.vo.SqlParam;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/schemeApprovalWarn/"})
public class SchemeApprovalWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PC_URL = "/ejc-scheme-frontend/#/schemeApproval/card?id=";
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private ISchemeApprovalService schemeApprovalService;

    @PostMapping(value={"schemeArgueDateDueWarnExecute"})
    public CommonResponse<String> schemeArgueDateDueWarnExecute(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u3010\u65b9\u6848\u8bba\u8bc1\u65f6\u95f4\u5230\u671f\u3011\u9884\u8b66\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u3010\u65b9\u6848\u8bba\u8bc1\u65f6\u95f4\u5ef6\u671f\u3011\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u3010\u65b9\u6848\u8bba\u8bc1\u65f6\u95f4\u5230\u671f\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u3010\u65b9\u6848\u8bba\u8bc1\u65f6\u95f4\u5230\u671f\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (Object param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        Object defaultParam = null;
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
        }
        List<Map<String, Object>> result = this.schemeApprovalService.queryArgumentDateDueWarn(sqlParamList);
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u3010\u65b9\u6848\u8bba\u8bc1\u65f6\u95f4\u5230\u671f\u3011\u9884\u8b66\u5b8c\u6210\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        return this.sendWarnToTask(this.transToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }

    @PostMapping(value={"schemeArgueDateOverWarnExecute"})
    public CommonResponse<String> schemeArgueDateOverWarnExecute(@RequestBody JSONObject jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList ignoreTenantIds = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)jsonParam.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray((String)jsonParam.getString("ignoreTenantIds"), Long.class));
        }
        this.logger.info("\u5ffd\u7565\u79df\u6237\u5217\u8868\uff1a{}", ignoreTenantIds);
        List billParams = JSONArray.parseArray((String)jsonParam.getString("billParams"), JSONObject.class);
        this.logger.info("\u9884\u8b66\u53c2\u6570\u5217\u8868\uff1a{}", (Object)billParams);
        JSONObject defaultWarnInfo = JSON.parseObject((String)jsonParam.getString("defaultParam"));
        this.logger.info("\u9884\u8b66\u9ed8\u8ba4\u8bbe\u7f6e\uff1a{}", (Object)defaultWarnInfo);
        CommonResponse tenantResp = this.tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            this.logger.error("\u6267\u884c\u3010\u65b9\u6848\u8bba\u8bc1\u65f6\u95f4\u5ef6\u671f\u3011\u9884\u8b66\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff1a{}", (Object)tenantResp.getMsg());
            return CommonResponse.error((String)"\u6267\u884c\u3010\u65b9\u6848\u8bba\u8bc1\u65f6\u95f4\u5ef6\u671f\u3011\u9884\u8b66\u5931\u8d25\uff0c\u83b7\u53d6\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u5931\u8d25\uff01");
        }
        List tenantIds = (List)tenantResp.getData();
        if (CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u3010\u65b9\u6848\u8bba\u8bc1\u65f6\u95f4\u5ef6\u671f\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        tenantIds.removeAll(ignoreTenantIds);
        if (CollectionUtils.isNotEmpty(ignoreTenantIds) && CollectionUtils.isEmpty((Collection)tenantIds)) {
            this.logger.error("\u6267\u884c\u3010\u65b9\u6848\u8bba\u8bc1\u65f6\u95f4\u5ef6\u671f\u3011\u9884\u8b66\u5b8c\u6210\uff0c\u6709\u6548\u7684\u79df\u6237Id\u5217\u8868\u4e3a\u7a7a\uff01", (Object)tenantResp.getMsg());
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        ArrayList<SqlParam> sqlParamList = new ArrayList<SqlParam>();
        Object warnInfo = null;
        List warnParamList = null;
        ArrayList<Long> customTenantIds = new ArrayList<Long>();
        for (Object param : billParams) {
            warnParamList = BeanMapper.mapList((Iterable)param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }
        tenantIds.removeAll(customTenantIds);
        Object defaultParam = null;
        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray((String)defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);
                p.setValue(p.getValue());
                sqlParamList.add(p);
            }
        }
        List<Map<String, Object>> result = this.schemeApprovalService.queryArgumentDateOverWarn(sqlParamList);
        if (CollectionUtils.isEmpty(result)) {
            this.logger.error("\u6267\u884c\u3010\u65b9\u6848\u8bba\u8bc1\u65f6\u95f4\u5ef6\u671f\u3011\u9884\u8b66\u5b8c\u6210\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u6709\u5339\u914d\u9884\u8b66\u89c4\u5219\u7684\u4fe1\u606f\uff01");
            return this.sendWarnToTask(new ArrayList<EarlyWarnTransVO>(), defaultWarnInfo.getLong("warnSetId"));
        }
        return this.sendWarnToTask(this.transToWarnVO(result, defaultWarnInfo), defaultWarnInfo.getLong("warnSetId"));
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        for (Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + m.get("billCode").toString());
            vo.setPcTitle("\u65bd\u5de5\u65b9\u6848\u62a5\u6279");
            vo.setPcUrl(PC_URL + m.get("id").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("id").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#schemeCode#", m.get("billCode").toString()).replaceAll("#schemeName#", m.get("schemeName").toString()).replaceAll("#days#", m.get("days").toString()).replaceAll("#planArgumentDate#", m.get("planArgumentDate") == null ? "" : m.get("planArgumentDate").toString()));
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(resp));
        return resp;
    }
}

