/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scheme.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.scheme.bean.SchemeCategoryEntity;
import com.ejianc.business.scheme.bean.SchemeDocEntity;
import com.ejianc.business.scheme.mapper.SchemeDocMapper;
import com.ejianc.business.scheme.service.ISchemeCategoryService;
import com.ejianc.business.scheme.service.ISchemeDocService;
import com.ejianc.business.scheme.utils.InnerCodeTool;
import com.ejianc.business.scheme.vo.SchemeDocVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="schemeDocService")
public class SchemeDocServiceImpl
extends BaseServiceImpl<SchemeDocMapper, SchemeDocEntity>
implements ISchemeDocService {
    private static final String DEF_DOC_TYPE_CODE = "scheme_grade";
    @Autowired
    private ISchemeCategoryService categoryService;
    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public List<SchemeDocEntity> queryListByCategoryId(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("category_id", new Parameter("like", (Object)id));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List oldEntities = super.queryList(param);
        return oldEntities;
    }

    @Override
    public CommonResponse<SchemeDocVO> saveOrUpdate(SchemeDocVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (saveorUpdateVO.getCategoryId() == null || saveorUpdateVO.getCategoryId() <= 0L) {
            throw new BusinessException("\u8bf7\u5148\u9009\u62e9\u65b9\u6848\u5206\u7c7b!");
        }
        SchemeDocEntity entity = (SchemeDocEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SchemeDocEntity.class));
        SchemeCategoryEntity schemeCategoryEntity = (SchemeCategoryEntity)((Object)this.categoryService.selectById(entity.getCategoryId()));
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity.setTenantId(tenantId);
            entity.setCategoryName(schemeCategoryEntity.getName());
            super.saveOrUpdate((Object)entity, false);
            SchemeDocVO vo = (SchemeDocVO)BeanMapper.map((Object)((Object)entity), SchemeDocVO.class);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
        }
        if (StringUtils.isBlank((String)entity.getSchemeCode())) {
            entity.setSchemeCode(this.creatCode(entity.getCategoryId(), tenantId));
        } else {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(SchemeDocEntity::getSchemeCode, (Object)entity.getSchemeCode());
            lambda.eq(BaseEntity::getDr, (Object)0);
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity.setCategoryName(schemeCategoryEntity.getName());
        super.saveOrUpdate((Object)entity, false);
        SchemeDocVO vo = (SchemeDocVO)BeanMapper.map((Object)((Object)entity), SchemeDocVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            Map<String, SchemeCategoryEntity> categoryCodeMap = this.queryCategoryCode(tenantId);
            Map<String, Long> docMap = this.queryDefDoc();
            List<String> codeList = this.queryCodeByTenantId(tenantId);
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<SchemeDocVO> errorList = new ArrayList<SchemeDocVO>();
            ArrayList<SchemeDocVO> successList = new ArrayList<SchemeDocVO>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                SchemeDocVO vo = new SchemeDocVO();
                vo.setId(Long.valueOf(IdWorker.getId()));
                boolean flag = false;
                String warnType = "";
                String categoryCode = (String)datas.get(0);
                String schemeCode = (String)datas.get(1);
                String schemeName = (String)datas.get(2);
                String schemeGradeName = (String)datas.get(3);
                String schemeParameter = (String)datas.get(4);
                vo.setCategoryCode(categoryCode);
                if (StringUtils.isNotBlank((String)categoryCode)) {
                    if (!categoryCodeMap.containsKey(categoryCode)) {
                        warnType = warnType + "\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728,";
                        flag = true;
                    } else {
                        SchemeCategoryEntity sce = categoryCodeMap.get(categoryCode);
                        vo.setCategoryId(sce.getId());
                        vo.setCategoryName(sce.getName());
                    }
                } else {
                    vo.setCategoryId(null);
                    vo.setCategoryName(null);
                    warnType = warnType + "\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                }
                if (StringUtils.isNotBlank((String)schemeCode)) {
                    if (codeList.contains(schemeCode)) {
                        warnType = warnType + "\u7f16\u7801\u5df2\u5b58\u5728,";
                        flag = true;
                    } else {
                        if (indexMap.containsKey(schemeCode)) {
                            return CommonResponse.error((String)("\u65b9\u6848\u7f16\u7801\uff1a\u7b2c" + ((Integer)indexMap.get(schemeCode) + 2) + "\u884c\u548c\u7b2c" + (i + 2) + "\u884c\u91cd\u590d\uff01"));
                        }
                        indexMap.put(schemeCode, i);
                    }
                    vo.setSchemeCode(schemeCode);
                } else {
                    vo.setSchemeCode(null);
                    warnType = warnType + "\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                }
                if (StringUtils.isBlank((String)schemeName)) {
                    vo.setSchemeName(null);
                    warnType = warnType + "\u65b9\u6848\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    vo.setSchemeName(schemeName);
                }
                if (StringUtils.isBlank((String)schemeGradeName)) {
                    vo.setSchemeGrade(null);
                    vo.setSchemeGradeName(null);
                    warnType = warnType + "\u65b9\u6848\u5206\u7ea7\u4e3a\u7a7a,";
                    flag = true;
                } else if (docMap.containsKey(schemeGradeName)) {
                    vo.setSchemeGrade(docMap.get(schemeGradeName));
                    vo.setSchemeGradeName(schemeGradeName);
                } else {
                    vo.setSchemeGrade(null);
                    vo.setSchemeGradeName(null);
                    warnType = warnType + "\u65b9\u6848\u5206\u7ea7\u4e0d\u5b58\u5728,";
                    flag = true;
                }
                if (StringUtils.isBlank((String)schemeParameter)) {
                    vo.setSchemeParameter(null);
                    warnType = warnType + "\u65b9\u6848\u53c2\u6570\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    vo.setSchemeParameter(schemeParameter);
                }
                vo.setTenantId(tenantId);
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                    vo.setDescription(warnType);
                    errorList.add(vo);
                    continue;
                }
                successList.add(vo);
            }
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)successList.size());
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public void insertBatch(List<SchemeDocEntity> list) {
        if (ListUtil.isNotEmpty(list)) {
            super.saveBatch(list);
        }
    }

    private Map<String, Long> queryDefDoc() {
        CommonResponse listCommonResponse = this.defdocApi.queryDetailListByDefdocCode(DEF_DOC_TYPE_CODE, null);
        if (listCommonResponse.isSuccess()) {
            List data = (List)listCommonResponse.getData();
            HashMap<String, Long> docMap = new HashMap<String, Long>();
            for (Map map : data) {
                docMap.put(map.get("name").toString(), Long.parseLong(map.get("id").toString()));
            }
            return docMap;
        }
        throw new BusinessException("\u67e5\u8be2\u65b9\u6848\u5206\u7ea7\u5931\u8d25!");
    }

    private List<String> queryCodeByTenantId(Long tenantId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List schemeCategoryEntities = super.queryList(param);
        List<String> codeList = schemeCategoryEntities.stream().map(SchemeDocEntity::getSchemeCode).collect(Collectors.toList());
        return codeList;
    }

    private String creatCode(Long pid, Long tenantid) {
        String pcode = this.categoryService.getPcode(pid);
        String getMaxCode = ((SchemeDocMapper)this.baseMapper).getMaxCode(pcode, tenantid, 3);
        String nextValue = InnerCodeTool.getNextValue((String)getMaxCode, (int)3);
        return pcode + nextValue;
    }

    private Map<String, SchemeCategoryEntity> queryCategoryCode(Long tenantId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List schemeCategoryEntities = this.categoryService.queryList(param);
        HashMap<String, SchemeCategoryEntity> codeMap = new HashMap<String, SchemeCategoryEntity>();
        for (SchemeCategoryEntity sce : schemeCategoryEntities) {
            codeMap.put(sce.getCode(), sce);
        }
        return codeMap;
    }
}

