package com.ejianc.business.scientific.sci.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.scientific.sci.vo.FeeConfirmDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 科研经费确认
 * 
 * @author generator
 * 
 */
public class FeeConfirmVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String billCode; // 单据编码
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织
    private Long projectId; // 科研项目主键
    private String projectName; // 科研项目名称
    private String projectType; // 科研项目类型:1-横向科研 2-纵向科研
    private Long managerId; // 项目负责人主键
    private String managerName; // 项目负责人
    private Long employeeId; // 经办人主键
    private String employeeName; // 经办人
    private Long deptId; // 经办部门主键
    private String deptName; // 经办部门
    private String memo; // 完成情况
    private String sourceType; // 单据来源：1-内部 2-外部
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    private BigDecimal budgetMny; // 经费预算
    private BigDecimal lastApplyMny; // 截止上期累计申请金额
    private BigDecimal sumApplyMny; // 累计申请金额
    private BigDecimal applyMny; // 本次申请金额
    
    private List<FeeConfirmDetailVO> detailList = new ArrayList<>(); // 科研经费确认-费用明细

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="sci-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getManagerId() {
        return managerId;
    }

    @ReferDeserialTransfer
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    public BigDecimal getLastApplyMny() {
        return lastApplyMny;
    }

    public void setLastApplyMny(BigDecimal lastApplyMny) {
        this.lastApplyMny = lastApplyMny;
    }
    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    
     public List<FeeConfirmDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<FeeConfirmDetailVO> detailList) {
        this.detailList = detailList;
     }
}
