package com.ejianc.business.scientific.sci.work.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 科研管理-科研工时填报
 * 
 * @author generator
 * 
 */
public class WorkTimeVO extends BaseVO {

    private static final long serialVersionUID = 8661184290727898042L;
    private Integer billState; // 单据状态
    private String billStateStr; // 单据状态
    private String billCode;//单据编码
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private Date effectiveDate; // 生效日期
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织
    private Long projectId; // 科研项目主键
    private String projectName; // 科研项目名称
    private String projectType; // 科研项目类型:1-横向科研 2-纵向科研
    private Long managerId; // 项目负责人主键
    private String managerName; // 项目负责人
    private Long employeeId; // 经办人主键
    private String employeeName; // 经办人
    private Long deptId; // 经办部门
    private String deptName; // 经办部门主键
    private String memo; // 备注
    private String yearMonth; // 月份
    private BigDecimal planTotalWorkTimeMonth; // 计划总工时(月)
    private BigDecimal projectTotalWorkTimeMonth; // 累计总工时(月),该科研项目所有已生效的科研工时填报单【本月总工时(月)】合计值
    private BigDecimal billTotalWorkTime; // 本月总工时(月),子表【本月工时】合计值
    private String sourceType; // 单据来源：1-内部 2-外部

    private String checkMsg; //查验结果

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getCheckMsg() {
        return checkMsg;
    }

    public void setCheckMsg(String checkMsg) {
        this.checkMsg = checkMsg;
    }

    private List<WorkTimeDetailVO> detailList = new ArrayList<>(); //项目成员

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public List<WorkTimeDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<WorkTimeDetailVO> detailList) {
        this.detailList = detailList;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "sci-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getManagerId() {
        return managerId;
    }

    @ReferDeserialTransfer
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getYearMonth() {
        return yearMonth;
    }

    public void setYearMonth(String yearMonth) {
        this.yearMonth = yearMonth;
    }

    public BigDecimal getPlanTotalWorkTimeMonth() {
        return planTotalWorkTimeMonth;
    }

    public void setPlanTotalWorkTimeMonth(BigDecimal planTotalWorkTimeMonth) {
        this.planTotalWorkTimeMonth = planTotalWorkTimeMonth;
    }
    public BigDecimal getProjectTotalWorkTimeMonth() {
        return projectTotalWorkTimeMonth;
    }

    public void setProjectTotalWorkTimeMonth(BigDecimal projectTotalWorkTimeMonth) {
        this.projectTotalWorkTimeMonth = projectTotalWorkTimeMonth;
    }
    public BigDecimal getBillTotalWorkTime() {
        return billTotalWorkTime;
    }

    public void setBillTotalWorkTime(BigDecimal billTotalWorkTime) {
        this.billTotalWorkTime = billTotalWorkTime;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }
}
