package com.ejianc.business.scientific.sci.cons;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 编码常量翻译
 */
public enum ProjectTypeEnum {

    // 科研项目类型:1-横向科研 2-纵向科研 3-建设公司科研项目 4-二级单位科研项目
    横向科研("1", "横向科研"),
    纵向科研("2", "纵向科研"),
    建设公司科研项目("3", "建设公司科研项目"),
    二级单位科研项目("4", "二级单位科研项目"),
    nullv(null, null),
    ;

    private final String name;
    private final String code;
    private static Map<String, ProjectTypeEnum> enumMap = new HashMap();

    private ProjectTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static ProjectTypeEnum getEnumByCode(String code) {
        return (ProjectTypeEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map)EnumSet.allOf(ProjectTypeEnum.class).stream().collect(Collectors.toMap(ProjectTypeEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
