package com.ejianc.business.scientific.sci.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.scientific.sci.vo.SciProjectUserVO;
import com.ejianc.business.scientific.sci.vo.SciProjectBudgetVO;
import com.ejianc.business.scientific.sci.vo.SciProjectTargetVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 科研项目立项
 * 
 * @author generator
 * 
 */
public class SciProjectVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 项目编码
    private String name; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织
    private String entrustOrg; // 委托单位
    private String executeOrg; // 实际执行单位
    private String projectType; // 科研项目类型:1-横向科研 2-纵向科研 3-建设公司科研项目 4-二级单位科研项目
    private String period; // 研究周期
    private Long managerId; // 项目负责人主键
    private String managerName; // 项目负责人
    private Long employeeId; // 经办人主键
    private String employeeName; // 经办人
    private Long deptId; // 经办部门主键
    private String deptName; // 经办部门
    private String memo; // 备注
    private String sourceType; // 单据来源：1-内部 2-外部
    private String projectStatus; // 项目状态：0-未验收 1-已验收
    private BigDecimal budgetMny; // 经费预算
    private BigDecimal planHour; // 计划总工时(月)
    private BigDecimal myselfMny; // 自筹经费
    private BigDecimal applyMny; // 申请经费
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectDate; // 立项日期
    private String technicalIndex; // 技术指标
    private String expectResult; // 预期成果
    private String background; // 研究背景
    private String researchArea; // 主要研究内容
    private String technology; // 关键技术及解决途径
    private String intellectual; // 知识产权策划
    private String forecast; // 经济与设备效益预测
    private String feasibility; // 可行性研究
    private Integer changeVersion; // 变更版本
    private String changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private String changeCode; // 变更单号
    private Long changeId; // 变更主键
    private String changeReason; // 变更原因
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private String projectCode; // 立项编号

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 结束日期
    
    private List<SciProjectUserVO> userList = new ArrayList<>(); // 科研项目立项-项目成员
    private List<SciProjectBudgetVO> budgetList = new ArrayList<>(); // 科研项目立项-经费预算
    private List<SciProjectTargetVO> targetList = new ArrayList<>(); // 科研项目立项-阶段目标

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getEntrustOrg() {
        return entrustOrg;
    }

    public void setEntrustOrg(String entrustOrg) {
        this.entrustOrg = entrustOrg;
    }
    public String getExecuteOrg() {
        return executeOrg;
    }

    public void setExecuteOrg(String executeOrg) {
        this.executeOrg = executeOrg;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getPeriod() {
        return period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getManagerId() {
        return managerId;
    }

    @ReferDeserialTransfer
    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    public BigDecimal getPlanHour() {
        return planHour;
    }

    public void setPlanHour(BigDecimal planHour) {
        this.planHour = planHour;
    }
    public BigDecimal getMyselfMny() {
        return myselfMny;
    }

    public void setMyselfMny(BigDecimal myselfMny) {
        this.myselfMny = myselfMny;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public Date getProjectDate() {
        return projectDate;
    }

    public void setProjectDate(Date projectDate) {
        this.projectDate = projectDate;
    }
    public String getTechnicalIndex() {
        return technicalIndex;
    }

    public void setTechnicalIndex(String technicalIndex) {
        this.technicalIndex = technicalIndex;
    }
    public String getExpectResult() {
        return expectResult;
    }

    public void setExpectResult(String expectResult) {
        this.expectResult = expectResult;
    }
    public String getBackground() {
        return background;
    }

    public void setBackground(String background) {
        this.background = background;
    }
    public String getResearchArea() {
        return researchArea;
    }

    public void setResearchArea(String researchArea) {
        this.researchArea = researchArea;
    }
    public String getTechnology() {
        return technology;
    }

    public void setTechnology(String technology) {
        this.technology = technology;
    }
    public String getIntellectual() {
        return intellectual;
    }

    public void setIntellectual(String intellectual) {
        this.intellectual = intellectual;
    }
    public String getForecast() {
        return forecast;
    }

    public void setForecast(String forecast) {
        this.forecast = forecast;
    }
    public String getFeasibility() {
        return feasibility;
    }

    public void setFeasibility(String feasibility) {
        this.feasibility = feasibility;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public List<SciProjectUserVO> getUserList() {
        return userList;
    }

    public void setUserList(List<SciProjectUserVO> userList) {
        this.userList = userList;
    }

    public List<SciProjectBudgetVO> getBudgetList() {
        return budgetList;
    }

    public void setBudgetList(List<SciProjectBudgetVO> budgetList) {
        this.budgetList = budgetList;
    }

    public List<SciProjectTargetVO> getTargetList() {
        return targetList;
    }

    public void setTargetList(List<SciProjectTargetVO> targetList) {
        this.targetList = targetList;
    }
}
