/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.result.service.impl;

import com.ejianc.business.scientific.result.MethodApproveVO;
import com.ejianc.business.scientific.result.bean.MethodApproveEntity;
import com.ejianc.business.scientific.result.bean.MethodReviewDetailEntity;
import com.ejianc.business.scientific.result.bean.MethodReviewEntity;
import com.ejianc.business.scientific.result.service.IMethodApproveService;
import com.ejianc.business.scientific.result.service.IMethodReviewService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="methodReview")
public class MethodReviewBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMethodApproveService methodApproveService;
    @Autowired
    private IMethodReviewService methodReviewService;
    private static final String BILL_CODE = "METHOD_APPROVE";
    @Autowired
    private IBillCodeApi billCodeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MethodReviewEntity methodReviewEntity = (MethodReviewEntity)((Object)this.methodReviewService.selectById(billId));
        methodReviewEntity.setReviewStatus(1);
        List<MethodReviewDetailEntity> methodReviewDetailList = methodReviewEntity.getMethodReviewDetailList();
        ArrayList<MethodApproveEntity> methodApproveEntityList = new ArrayList<MethodApproveEntity>();
        for (MethodReviewDetailEntity methodReviewDetailEntity : methodReviewDetailList) {
            List approveIds = Optional.ofNullable(methodReviewDetailEntity.getApproveId()).map(str -> Arrays.stream(str.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(s -> {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList())).orElse(Collections.emptyList());
            for (Long approveId : approveIds) {
                MethodApproveEntity methodApproveEntity = (MethodApproveEntity)((Object)BeanMapper.map((Object)((Object)methodReviewDetailEntity), MethodApproveEntity.class));
                methodApproveEntity.setId(IdWorker.getId());
                methodApproveEntity.setCreateTime(new Date());
                methodApproveEntity.setEmployeeId(methodReviewEntity.getEmployeeId());
                methodApproveEntity.setEmployeeName(methodReviewEntity.getEmployeeName());
                methodApproveEntity.setApproveId(approveId.toString());
                methodApproveEntity.setMethodApproveDetailId(methodReviewDetailEntity.getId());
                methodApproveEntity.setApproveStatus(1);
                MethodApproveVO methodApproveVO = (MethodApproveVO)BeanMapper.map((Object)((Object)methodApproveEntity), MethodApproveVO.class);
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)methodApproveVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                methodApproveEntity.setBillCode((String)billCode.getData());
                methodApproveEntityList.add(methodApproveEntity);
            }
        }
        this.methodApproveService.saveBatch(methodApproveEntityList);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e,\u4e0d\u80fd\u5f03\u5ba1");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

