/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scientific.sci.bean.SciProjectEntity;
import com.ejianc.business.scientific.sci.service.ISciProjectService;
import com.ejianc.business.scientific.sci.vo.SciProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sciProject"})
public class SciProjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE_IN = "IN_SCI_PROJECT";
    private static final String BILL_CODE_OUT = "OUT_SCI_PROJECT";
    @Autowired
    private ISciProjectService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SciProjectVO> saveOrUpdate(@RequestBody SciProjectVO saveOrUpdateVO) {
        SciProjectEntity entity = (SciProjectEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SciProjectEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            String rule = "1".equals(entity.getSourceType()) ? BILL_CODE_IN : BILL_CODE_OUT;
            BillCodeParam billCodeParam = BillCodeParam.build((String)rule, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SciProjectVO vo = (SciProjectVO)BeanMapper.map((Object)((Object)entity), SciProjectVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SciProjectVO> queryDetail(Long id) {
        SciProjectEntity entity = (SciProjectEntity)((Object)this.service.selectById(id));
        SciProjectVO vo = (SciProjectVO)BeanMapper.map((Object)((Object)entity), SciProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SciProjectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SciProjectVO sciProjectVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SciProjectVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "orgName", "name", "managerName", "employeeName", "deptName", "entrustOrg", "executeOrg"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SciProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "orgName", "name", "managerName", "employeeName", "deptName", "entrustOrg", "executeOrg"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List records = BeanMapper.mapList((Iterable)list, SciProjectVO.class);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", records);
        String sourceType = null;
        if (param.getParams().containsKey("sourceType")) {
            sourceType = String.valueOf(((Parameter)param.getParams().get("sourceType")).getValue());
        }
        if ("1".equals(sourceType)) {
            ExcelExport.getInstance().exportWithTrans("SciProject-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().exportWithTrans("OutSciProject-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/queryTypeTree"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray queryTypeTree() {
        JSONArray result = new JSONArray();
        JSONObject parent1 = new JSONObject();
        parent1.put("id", (Object)IdWorker.getId());
        parent1.put("name", (Object)"\u5916\u90e8\u79d1\u7814\u9879\u76ee");
        parent1.put("projectType", (Object)"1,2");
        JSONArray child1 = new JSONArray();
        JSONObject child11 = new JSONObject();
        child11.put("id", (Object)IdWorker.getId());
        child11.put("name", (Object)"\u6a2a\u5411\u79d1\u7814\u9879\u76ee");
        child11.put("projectType", (Object)"1");
        child11.put("parentId", (Object)parent1.getLong("id"));
        child1.add((Object)child11);
        JSONObject child12 = new JSONObject();
        child12.put("id", (Object)IdWorker.getId());
        child12.put("name", (Object)"\u7eb5\u5411\u79d1\u7814\u9879\u76ee");
        child12.put("projectType", (Object)"2");
        child12.put("parentId", (Object)parent1.getLong("id"));
        child1.add((Object)child12);
        parent1.put("children", (Object)child1);
        result.add((Object)parent1);
        JSONObject parent2 = new JSONObject();
        parent2.put("id", (Object)IdWorker.getId());
        parent2.put("name", (Object)"\u5185\u90e8\u79d1\u7814\u9879\u76ee");
        parent2.put("projectType", (Object)"3,4");
        JSONArray child2 = new JSONArray();
        JSONObject child21 = new JSONObject();
        child21.put("id", (Object)IdWorker.getId());
        child21.put("name", (Object)"\u5efa\u8bbe\u516c\u53f8\u79d1\u7814\u9879\u76ee");
        child21.put("projectType", (Object)"3");
        child21.put("parentId", (Object)parent2.getLong("id"));
        child2.add((Object)child21);
        JSONObject child22 = new JSONObject();
        child22.put("id", (Object)IdWorker.getId());
        child22.put("name", (Object)"\u4e8c\u7ea7\u5355\u4f4d\u79d1\u7814\u9879\u76ee");
        child22.put("projectType", (Object)"4");
        child22.put("parentId", (Object)parent2.getLong("id"));
        child2.add((Object)child22);
        parent2.put("children", (Object)child2);
        result.add((Object)parent2);
        return result;
    }

    @RequestMapping(value={"/refSciProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SciProjectVO>> refSciProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"orgId")) {
                orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            }
            if (_con.containsKey((Object)"range") && "up".equals(_con.getString("range"))) {
                List orgIds = ((List)this.iOrgApi.findParentsByOrgId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
                param.getParams().put("orgId", new Parameter("in", orgIds));
            }
            if (_con.containsKey((Object)"sourceType")) {
                param.getParams().put("sourceType", new Parameter("eq", (Object)_con.getString("sourceType")));
            }
            if (_con.containsKey((Object)"projectType")) {
                param.getParams().put("projectType", new Parameter("in", (Object)_con.getString("projectType")));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SciProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateProjectCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SciProjectVO> updateProjectCode(@RequestParam(value="id") Long id, @RequestParam(value="projectCode") String projectCode) {
        SciProjectEntity entity = (SciProjectEntity)((Object)this.service.selectById(id));
        entity.setProjectCode(projectCode);
        this.service.saveOrUpdate((Object)entity, false);
        SciProjectVO vo = (SciProjectVO)BeanMapper.map((Object)((Object)entity), SciProjectVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

