/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityUtil<T> {
    private static Logger logger = LoggerFactory.getLogger(EntityUtil.class);
    private static IBillCodeApi billCodeApi;

    @Autowired
    private void setBillCodeApi(IBillCodeApi billCodeApi) {
        EntityUtil.billCodeApi = billCodeApi;
    }

    public static <T> String createBillCode(T t, String ruleCode) {
        JSONObject paramJson = JSONObject.parseObject((String)JSONObject.toJSONString(t));
        BillCodeParam billCodeParam = BillCodeParam.build((String)ruleCode, (Long)InvocationInfoProxy.getTenantid(), (JSONObject)paramJson);
        CommonResponse billCode = billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return (String)billCode.getData();
    }

    public static void saveOrUpdate(JSONObject entity, Class<?> mainClass) {
        String className = mainClass.getSimpleName();
        className = className.substring(0, 1).toLowerCase() + className.substring(1);
        String serviceName = className.substring(0, className.lastIndexOf("Entity")) + "Service";
        BaseServiceImpl service = (BaseServiceImpl)ContextUtil.getBean((String)serviceName, BaseServiceImpl.class);
        service.saveOrUpdate(BeanMapper.map((Object)entity, mainClass), false);
    }

    public static <T> Long saveOrUpdate(T entity) {
        Class<?> mainClass = entity.getClass();
        String className = mainClass.getSimpleName();
        className = className.substring(0, 1).toLowerCase() + className.substring(1);
        String serviceName = className.substring(0, className.lastIndexOf("Entity")) + "Service";
        BaseServiceImpl service = (BaseServiceImpl)ContextUtil.getBean((String)serviceName, BaseServiceImpl.class);
        service.saveOrUpdate(entity, false);
        return EntityUtil.getLong(entity, "id");
    }

    public static void clearInvalidData(JSONObject entity) {
        entity.put("id", null);
        entity.put("createTime", null);
        entity.put("updateTime", null);
        entity.put("tenantId", (Object)InvocationInfoProxy.getTenantid());
        entity.put("updateUserCode", null);
        entity.put("createUserCode", null);
    }

    public static <T extends BaseEntity> void clearInvalidData(T entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setUpdateTime(null);
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setUpdateUserCode(null);
        entity.setCreateUserCode(null);
    }

    public static <T extends BaseVO> void clearInvalidData(T vo) {
        vo.setId(null);
        vo.setCreateTime(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setCreateUserCode(null);
    }

    public static <S, T extends BaseEntity> S clearInvalidEntity(T entity, Class<S> clazz) {
        return (S)BeanMapper.map(EntityUtil.clearInvalidEntity(entity), clazz);
    }

    public static <T extends BaseEntity> T clearInvalidEntity(T entity) {
        Field[] fields;
        Class<?> clazz = entity.getClass();
        BaseEntity result = (BaseEntity)BeanMapper.map(entity, clazz);
        Long id = result.getId();
        EntityUtil.setValue(result, "sourceId", id);
        EntityUtil.clearInvalidData(result);
        Class<?> mainClass = result.getClass();
        for (Field field : fields = mainClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(SubEntity.class)) continue;
            SubEntity subEntity = field.getAnnotation(SubEntity.class);
            List<BaseEntity> subList = EntityUtil.castList(EntityUtil.getValue(result, field.getName()), BaseEntity.class);
            for (BaseEntity detail : subList) {
                EntityUtil.setValue(detail, "sourceId", detail.getId());
                EntityUtil.clearInvalidData(detail);
            }
            if (ListUtil.isEmpty(subList)) continue;
            EntityUtil.setValue(result, field.getName(), subList);
        }
        return (T)result;
    }

    public static <T extends BaseEntity, S extends BaseEntity> T transformFileds(T target, S source) {
        Field[] fields;
        logger.info("\u540c\u6b65\u6570\u636e\u5f00\u59cb\uff0c\u540c\u6b65\u524d\u6570\u636e\uff1a{}\uff0c\u6765\u6e90\u6570\u636e", target, source);
        Class<?> clazz = target.getClass();
        BaseEntity copy = (BaseEntity)BeanMapper.map(target, clazz);
        BaseEntity result = (BaseEntity)BeanMapper.map(source, clazz);
        Long id = source.getId();
        EntityUtil.setValue(result, "sourceId", id);
        EntityUtil.setValue(result, "id", copy.getId());
        EntityUtil.setValue(result, "version", EntityUtil.getValue(copy, "version"));
        Class<?> mainClass = target.getClass();
        for (Field field : fields = mainClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(SubEntity.class)) continue;
            SubEntity subEntity = field.getAnnotation(SubEntity.class);
            List<T> detailList = EntityUtil.castList(EntityUtil.getValue(copy, field.getName()), BaseEntity.class);
            Map<Long, BaseEntity> detailMap = detailList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
            List<BaseEntity> subList = EntityUtil.castList(EntityUtil.getValue(result, field.getName()), BaseEntity.class);
            for (BaseEntity sub : subList) {
                if (!detailMap.containsKey(EntityUtil.getLong(sub, "sourceDetailId"))) continue;
                BaseEntity vo = detailMap.get(EntityUtil.getLong(sub, "sourceDetailId"));
                EntityUtil.setValue(sub, "sourceId", id);
                EntityUtil.setValue(sub, "sourceDetailId", sub.getId());
                sub.setId(vo.getId());
                sub.setVersion(vo.getVersion());
            }
            List subIds = subList.stream().map(x -> x.getId()).collect(Collectors.toList());
            List delList = detailList.stream().filter(x -> !subIds.contains(x.getId())).map(x -> {
                x.setRowState("del");
                return x;
            }).collect(Collectors.toList());
            subList.addAll(delList);
            if (ListUtil.isEmpty(subList)) continue;
            EntityUtil.setValue(result, field.getName(), subList);
        }
        logger.info("\u540c\u6b65\u6570\u636e\u7ed3\u675f\uff0c\u540c\u6b65\u540e\u6570\u636e\uff1a{}", (Object)result);
        return (T)result;
    }

    public static <T extends BaseEntity, S extends BaseEntity> T syncDetail(T target, S source, String sourceFildName) {
        Field[] fields;
        logger.info("\u540c\u6b65\u6570\u636e\u5f00\u59cb\uff0c\u540c\u6b65\u524d\u6570\u636e\uff1a{}\uff0c\u6765\u6e90\u6570\u636e", target, source);
        Class<?> mainClass = target.getClass();
        for (Field field : fields = mainClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(SubEntity.class)) continue;
            SubEntity subEntity = field.getAnnotation(SubEntity.class);
            Class<?> clazz = subEntity.getClass();
            List<T> targetList = EntityUtil.castList(EntityUtil.getValue(target, field.getName()), BaseEntity.class);
            Map<Long, BaseEntity> targetMap = targetList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
            List<BaseEntity> sourceList = EntityUtil.castList(EntityUtil.getValue(source, field.getName()), BaseEntity.class);
            List sourceIds = sourceList.stream().map(x -> EntityUtil.getLong(x, sourceFildName)).filter(Objects::nonNull).collect(Collectors.toList());
            ArrayList<Object> subList = new ArrayList<Object>();
            for (BaseEntity detail : sourceList) {
                if (EntityUtil.getLong(detail, sourceFildName) != null) {
                    detail.setId(EntityUtil.getLong(detail, sourceFildName));
                } else {
                    detail.setId(null);
                    detail.setRowState("add");
                }
                if (targetMap.containsKey(detail.getId())) {
                    BaseEntity vo = targetMap.get(detail.getId());
                    detail.setVersion(vo.getVersion());
                }
                subList.add(BeanMapper.map((Object)detail, clazz));
            }
            for (BaseEntity vo : targetMap.values()) {
                if (sourceIds.contains(vo.getId())) continue;
                vo.setRowState("del");
                subList.add(vo);
            }
            if (ListUtil.isEmpty(subList)) continue;
            EntityUtil.setValue(target, field.getName(), subList);
        }
        logger.info("\u540c\u6b65\u6570\u636e\u7ed3\u675f\uff0c\u540c\u6b65\u540e\u6570\u636e\uff1a{}", target);
        return target;
    }

    public static <T> Long getLong(T t, String fieldName) {
        Object obj = EntityUtil.getValue(t, fieldName);
        if (obj instanceof Long) {
            return Long.valueOf(String.valueOf(obj));
        }
        return null;
    }

    public static <T> Object getValue(T t, String fieldName) {
        for (Class<?> clazz = t.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Method m = clazz.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), null);
                try {
                    return m.invoke(t, (Object[])null);
                }
                catch (IllegalAccessException e) {
                    throw new BusinessException("\u7c7b\u3010" + clazz + "\u3011\u7684\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
                }
                catch (InvocationTargetException e) {
                    throw new BusinessException("\u7c7b\u3010" + clazz + "\u3011\u7684\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
                }
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static <T> void setValue(T t, String fieldName, Object obj) {
        for (Class<?> clazz = t.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                Method m = clazz.getDeclaredMethod("set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), field.getType());
                try {
                    m.invoke(t, obj);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new BusinessException("\u7c7b\u3010" + clazz + "\u3011\u7684\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
                }
                catch (InvocationTargetException e) {
                    throw new BusinessException("\u7c7b\u3010" + clazz + "\u3011\u7684\u5b57\u6bb5\u3010" + fieldName + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T> List<T> castList(Object obj, Class<?> clazz) {
        ArrayList result = new ArrayList();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(clazz.cast(o));
            }
        }
        return result;
    }
}

