/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.service.impl;

import com.ejianc.business.scientific.sci.bean.SciProjectEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectUserEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectUserHourEntity;
import com.ejianc.business.scientific.sci.mapper.SciProjectMapper;
import com.ejianc.business.scientific.sci.service.ISciProjectService;
import com.ejianc.business.scientific.sci.service.ISciProjectUserHourService;
import com.ejianc.business.scientific.sci.service.ISciProjectUserService;
import com.ejianc.business.scientific.sci.utils.DateUtil;
import com.ejianc.business.scientific.sci.vo.SciProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sciProjectService")
public class SciProjectServiceImpl
extends BaseServiceImpl<SciProjectMapper, SciProjectEntity>
implements ISciProjectService {
    private static final String BILL_CODE_IN = "IN_SCI_PROJECT";
    private static final String BILL_CODE_OUT = "OUT_SCI_PROJECT";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISciProjectUserService userService;
    @Autowired
    private ISciProjectUserHourService hourService;

    @Override
    public SciProjectVO saveOrUpdate(SciProjectVO saveOrUpdateVO) {
        SciProjectEntity entity = (SciProjectEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SciProjectEntity.class));
        if (CollectionUtils.isNotEmpty(entity.getUserList())) {
            for (SciProjectUserEntity user : entity.getUserList()) {
                for (SciProjectUserHourEntity hour : user.getHourList()) {
                    hour.setUserId(user.getUserId());
                    hour.setUserName(user.getUserName());
                    if (!"del".equals(user.getRowState())) continue;
                    hour.setRowState("del");
                }
            }
        }
        this.validateHourByUser(entity.getUserList());
        if (entity.getId() == null || entity.getId() == 0L) {
            String rule = "1".equals(entity.getSourceType()) ? BILL_CODE_IN : BILL_CODE_OUT;
            BillCodeParam billCodeParam = BillCodeParam.build((String)rule, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getUserList())) {
            for (SciProjectUserEntity user : entity.getUserList()) {
                this.userService.saveOrUpdate((Object)user, false);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        SciProjectVO vo = (SciProjectVO)BeanMapper.map((Object)((Object)entity), SciProjectVO.class);
        return vo;
    }

    private void validateHourByUser(List<SciProjectUserEntity> userList) {
        List dataList;
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        List list = userList.stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List saveList = list.stream().map(x -> x.getHourList()).flatMap(Collection::stream).filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        List userIds = list.stream().map(x -> x.getUserId()).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("userId", new Parameter("in", userIds));
        List ids = saveList.stream().map(x -> x.getId()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            param.getParams().put("id", new Parameter("not_in", ids));
        }
        dataList = CollectionUtils.isNotEmpty((Collection)(dataList = this.hourService.queryList(param))) ? dataList : new ArrayList();
        dataList.addAll(saveList);
        Map<Long, Map<String, List<SciProjectUserHourEntity>>> userMap = dataList.stream().collect(Collectors.groupingBy(x -> x.getUserId(), Collectors.groupingBy(x -> DateUtil.getYearStr(x.getPlanYear()))));
        StringBuilder message = new StringBuilder();
        for (Long userId : userMap.keySet()) {
            Map<String, List<SciProjectUserHourEntity>> yearMap = userMap.get(userId);
            for (String year : yearMap.keySet()) {
                BigDecimal hour = yearMap.get(year).stream().map(x -> x.getPlanHour()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
                if (!ComputeUtil.isGreaterThan((BigDecimal)hour, (BigDecimal)ComputeUtil.toBigDecimal((String)"12"))) continue;
                message.append("\u3010" + yearMap.get(year).get(0).getUserName() + "\u3011");
                message.append("\u5728\u3010" + year + "\u5e74\u3011\u53c2\u4e0e\u7684\u6240\u6709\u79d1\u7814\u9879\u76ee\u7acb\u9879\u4e2d\u7684\u8ba1\u5212\u5de5\u65f6\u7d2f\u8ba1\u503c\u5df2\u8d8512\u4e2a\u6708\uff1b/n");
            }
        }
        if (message.length() > 0) {
            throw new BusinessException(message.toString());
        }
    }
}

