package com.ejianc.business.scientific.sci.work.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.sci.work.mapper.WorkTimeDetailMapper;
import com.ejianc.business.scientific.sci.work.bean.WorkTimeDetailEntity;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeDetailService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 科研管理-科研工时填报子表明细
 * 
 * @author generator
 * 
 */
@Service("workTimeDetailService")
public class WorkTimeDetailServiceImpl extends BaseServiceImpl<WorkTimeDetailMapper, WorkTimeDetailEntity> implements IWorkTimeDetailService{


    @Autowired
    private WorkTimeDetailMapper mapper;

    @Override
    public Map<Long, BigDecimal> countUserWorkTime(List<Long> userIds, String yearMonth, Long pid, Long projectId) {
        Map<Long, BigDecimal> resp = new HashMap<>();
        List<Map<String, Object>> result = mapper.countUserWorkTime(userIds, yearMonth, pid, projectId);
        if(CollectionUtils.isNotEmpty(result)) {
            for(Map m : result) {
                resp.put(Long.valueOf(m.get("userId").toString()), new BigDecimal(m.get("totalHour").toString()));
            }
        }
        return resp;
    }

    @Override
    public Map<Long, List<JSONObject>> queryUserWorkTime(List<Long> userIds, String yearMonth, Long pid, Long projectId) {
        List<Map<String, Object>> result = mapper.queryUserWorkTime(userIds, yearMonth, pid, projectId);
        List<JSONObject> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(result)) {
            for(Map m : result) {
                JSONObject obj = new JSONObject();
                obj.put("userId", Long.valueOf(m.get("userId").toString()));
                obj.put("totalHour", ComputeUtil.toBigDecimal(m.get("totalHour")));
                obj.put("projectName", m.get("projectName").toString());
                list.add(obj);
            }
        }
        Map<Long, List<JSONObject>> resp = list.stream().collect(Collectors.groupingBy(x->x.getLong("userId")));
        return resp;
    }
}
