package com.ejianc.business.scientific.result.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.scientific.result.MethodFileVO;
import com.ejianc.business.scientific.result.MethodFileVO;
import com.ejianc.business.scientific.result.MethodFileVO;
import com.ejianc.business.scientific.result.bean.*;
import com.ejianc.business.scientific.result.service.IMethodApplyService;
import com.ejianc.business.scientific.result.service.IMethodFileDetailService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.result.mapper.MethodFileMapper;
import com.ejianc.business.scientific.result.bean.MethodFileEntity;
import com.ejianc.business.scientific.result.service.IMethodFileService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 工法管理-工法文件
 * 
 * @author generator
 * 
 */
@Service("methodFileService")
public class MethodFileServiceImpl extends BaseServiceImpl<MethodFileMapper, MethodFileEntity> implements IMethodFileService{
    private static final String BILL_CODE = "SCIENTIFIC-METHOD-FILE";//
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMethodApplyService methodApplyService;
    @Autowired
    private IMethodFileDetailService methodFileDetailService;
    
    @Override
    public MethodFileVO saveOrUpdate(MethodFileVO saveOrUpdateVO) {
        MethodFileEntity entity = BeanMapper.map(saveOrUpdateVO, MethodFileEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //同步引用状态
        if (saveOrUpdateVO.getId() != null){
            MethodFileEntity methodFileEntity = super.selectById(saveOrUpdateVO.getId());
            List<MethodFileDetailEntity> methodFileDetailList = methodFileEntity.getMethodFileDetailList();
            if (CollectionUtils.isNotEmpty(methodFileDetailList)){
                List<Long> methodIds = methodFileDetailList.stream().map(MethodFileDetailEntity::getMethodId).collect(Collectors.toList());
                LambdaQueryWrapper<MethodApplyEntity> lambda = new LambdaQueryWrapper();
                lambda.in(MethodApplyEntity::getId, methodIds);
                List<MethodApplyEntity> methodApplyEntities = methodApplyService.list(lambda);
                if (CollectionUtils.isNotEmpty(methodApplyEntities)){
                    for (MethodApplyEntity methodApplyEntity : methodApplyEntities){
                        methodApplyEntity.setFileUseStatus(0);
                    }
                    methodApplyService.updateBatchById(methodApplyEntities);
                }
            }
        }

        super.saveOrUpdate(entity, false);

        List<MethodFileDetailEntity> methodFileDetailList = entity.getMethodFileDetailList();
        if (CollectionUtils.isNotEmpty(methodFileDetailList)){
            List<Long> methodIds = methodFileDetailList.stream().map(MethodFileDetailEntity::getMethodId).collect(Collectors.toList());
            LambdaQueryWrapper<MethodApplyEntity> lambda = new LambdaQueryWrapper();
            lambda.in(MethodApplyEntity::getId, methodIds);
            List<MethodApplyEntity> methodApplyEntities = methodApplyService.list(lambda);
            if (CollectionUtils.isNotEmpty(methodApplyEntities)){
                for (MethodApplyEntity methodApplyEntity : methodApplyEntities){
                    methodApplyEntity.setFileUseStatus(1);
                }
                methodApplyService.updateBatchById(methodApplyEntities);
            }

        }

        MethodFileVO vo = BeanMapper.map(entity, MethodFileVO.class);
        return vo;
    }

    @Override
    public void delete(List<MethodFileVO> vos) {
        List<Long> ids = vos.stream().map(MethodFileVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<MethodFileDetailEntity> methodFileDetailLambdaWrapper = new LambdaQueryWrapper();
        methodFileDetailLambdaWrapper.in(MethodFileDetailEntity::getMid, ids);
        List<MethodFileDetailEntity> methodFileDetailEntities = methodFileDetailService.list(methodFileDetailLambdaWrapper);
        List<Long> methodIds = methodFileDetailEntities.stream().map(MethodFileDetailEntity::getMethodId).collect(Collectors.toList());
        LambdaQueryWrapper<MethodApplyEntity> lambda = new LambdaQueryWrapper();
        lambda.in(MethodApplyEntity::getId, methodIds);
        List<MethodApplyEntity> methodApplyEntities = methodApplyService.list(lambda);
        for (MethodApplyEntity methodApplyEntity : methodApplyEntities){
            methodApplyEntity.setFileUseStatus(0);
        }
        methodApplyService.updateBatchById(methodApplyEntities);

        super.removeByIds(vos.stream().map(MethodFileVO::getId).collect(Collectors.toList()),true);
    }
}
