package com.ejianc.business.scientific.sci.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/**
 * @author yqls
 * @date 2022-02-14 14:13:47
 */
public class ListCallable implements Callable<JSONArray> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private RequestAttributes context = RequestContextHolder.getRequestAttributes();
    private String url;
    private QueryParam queryParam;
    private IBaseService service;
    private Boolean pageDataResp = true;

    /**
     *  注入service使用Callable查询数据列表
     * @param threadPool
     * @param queryParam
     * @param service
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     */
    public static Future<JSONArray> excute(ExecutorService threadPool, QueryParam queryParam, IBaseService service) {
        Callable<JSONArray> callable = new ListCallable(queryParam, service);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    public ListCallable(QueryParam queryParam, IBaseService service) {
        this.queryParam = queryParam;
        this.service = service;
    }

    public static Future<JSONArray> excute(ExecutorService threadPool, String url, QueryParam queryParam) {
        Callable<JSONArray> callable = new ListCallable(url, queryParam);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    public static Future<JSONArray> excute(ExecutorService threadPool, String url, QueryParam queryParam, boolean pageDataResp) {
        Callable<JSONArray> callable = new ListCallable(url, queryParam, pageDataResp);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    public ListCallable(String url, QueryParam queryParam) {
        this.url = url;
        this.queryParam = queryParam;
    }
    public ListCallable(String url, QueryParam queryParam, Boolean pageDataResp) {
        this.url = url;
        this.queryParam = queryParam;
        this.pageDataResp = pageDataResp;
    }

    @Override
    public JSONArray call() throws Exception {
        if(service == null){
            RequestContextHolder.setRequestAttributes(context);
            String resp = HttpTookit.postByJson(url, JSONObject.toJSONString(queryParam));
            JSONObject json = JSONObject.parseObject(resp);
            if(json.getInteger("code") != 0){
                logger.error("获取URL-{}列表失败：{}", url, json.getString("msg"));
                return new JSONArray();
            }

            if(pageDataResp) {
                JSONObject data = json.getJSONObject("data");
                if(data == null){
                    return new JSONArray();
                }
                return data.getJSONArray("records");
            } else {
                return json.getJSONArray("data");
            }

        } else {
            List<T> list = service.queryList(queryParam, false);
//        DetailListUtil.setDetailList(list);
            String json = JSON.toJSONString(list);
            JSONArray records = JSONArray.parseArray(json);
            return records;
        }
    }
}
