package com.ejianc.business.scientific.sci.work.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;
/**
 * 员工月度工时统计主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_scientific_work_time_static")
public class UserMonthWorkTimeStaticEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="employee_id")
    private Long employeeId; // 经办人主键
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="year_month")
    private String yearMonth; // 月份
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="userMonthWorkTimeStaticDetailService")
    private List<UserMonthWorkTimeStaticDetailEntity> detailList = new ArrayList<>(); // 员工月度工时统计子表
    
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getYearMonth() {
        return yearMonth;
    }

    public void setYearMonth(String yearMonth) {
        this.yearMonth = yearMonth;
    }

    public List<UserMonthWorkTimeStaticDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<UserMonthWorkTimeStaticDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
