package com.ejianc.business.scientific.sci.work.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scientific.sci.work.bean.UserMonthWorkTimeStaticEntity;
import com.ejianc.business.scientific.sci.work.service.IUserMonthWorkTimeStaticService;
import com.ejianc.business.scientific.sci.work.vo.UserMonthWorkTimeStaticVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 员工月度工时统计主表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("userMonthWorkTimeStatic")
public class UserMonthWorkTimeStaticController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "RYYDGS";//此处需要根据实际修改

    @Autowired
    private IUserMonthWorkTimeStaticService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UserMonthWorkTimeStaticVO> saveOrUpdate(@RequestBody UserMonthWorkTimeStaticVO saveOrUpdateVO) {
    	UserMonthWorkTimeStaticEntity entity = BeanMapper.map(saveOrUpdateVO, UserMonthWorkTimeStaticEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setBillOrgId(InvocationInfoProxy.getOrgId());
        }
    	service.saveOrUpdate(entity, false);
    	UserMonthWorkTimeStaticVO vo = BeanMapper.map(entity, UserMonthWorkTimeStaticVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @PostMapping(value = "/queryByYearMonth")
    @ResponseBody
    public CommonResponse<UserMonthWorkTimeStaticVO> queryByYearMonth(@RequestBody UserMonthWorkTimeStaticVO staticVO) {
        UserMonthWorkTimeStaticEntity e = service.getByYearMonth(staticVO.getYearMonth());
        if(null == e) {
            e = service.staticByYearMonth(staticVO.getYearMonth());
        }

        return CommonResponse.success(BeanMapper.map(e, UserMonthWorkTimeStaticVO.class));
    }

    @PostMapping(value = "/checkByYearMonth")
    @ResponseBody
    public CommonResponse<UserMonthWorkTimeStaticVO> checkByYearMonth(@RequestBody UserMonthWorkTimeStaticVO staticVO) {
        UserMonthWorkTimeStaticEntity e = service.getByYearMonth(staticVO.getYearMonth());

        return CommonResponse.success(null != e ?
                BeanMapper.map(e, UserMonthWorkTimeStaticVO.class) : null);
    }


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UserMonthWorkTimeStaticVO> queryDetail(Long id) {
    	UserMonthWorkTimeStaticEntity entity = service.selectById(id);
    	UserMonthWorkTimeStaticVO vo = BeanMapper.map(entity, UserMonthWorkTimeStaticVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UserMonthWorkTimeStaticVO> vos) {
        service.removeByIds(vos.stream().map(UserMonthWorkTimeStaticVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UserMonthWorkTimeStaticVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("billOrgId", Parameter.getInInstance(commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("billOrgId", Parameter.getInInstance(departmentIds));
        }

        IPage<UserMonthWorkTimeStaticEntity> page = service.queryPage(param,false);
        IPage<UserMonthWorkTimeStaticVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), UserMonthWorkTimeStaticVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("billOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<UserMonthWorkTimeStaticEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("UserMonthWorkTimeStatic-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refUserMonthWorkTimeStaticData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UserMonthWorkTimeStaticVO>> refUserMonthWorkTimeStaticData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<UserMonthWorkTimeStaticEntity> page = service.queryPage(param,false);
        IPage<UserMonthWorkTimeStaticVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UserMonthWorkTimeStaticVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
