package com.ejianc.business.capital.util;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author CJ
 * @Description:
 * @date 2021/10/19 20:12
 */
public class MoneyUtils {

    /**
     * 汉字的数字
     */
    private static final String[] CN_NUMS = new String[]{"零", "壹", "贰", "叁", "肆", "伍", "陆", "柒", "捌", "玖"};

    /**
     * 基本单位
     */
    private static final String[] CN_INT_RADICE = new String[]{"", "拾", "佰", "仟"};

    /**
     * 对应整数部分扩展单位
     */
    private static final String[] CN_INT_UNITS = new String[]{"", "万", "亿", "兆"};

    /**
     * 对应小数部分单位
     */
    private static final String[] CN_DEC_UNINTS = new String[]{"角", "分", "毫", "厘"};

    private static final String CN_INTEGER = "整";
    private static final String CN_INT_LAST = "元";

    /**
     * 最大处理的数字
     */
    private static final BigDecimal MAX_HANDLER = new BigDecimal("99999999999999.9999");

    public static String getMnyUpCase(BigDecimal mny) {
        StringBuffer chineseStr = new StringBuffer();
        if(null == mny) {
            return "";
        }
        if(MAX_HANDLER.compareTo(mny) < 0) {
            //超出最大处理数字
            return "";
        }
        if(mny.signum() == 0) {
            chineseStr.append(CN_NUMS[0]).append(CN_INT_LAST).append(CN_INTEGER);
        } else {
            //转为字符串
            String mnyStr = mny.toString();
            BigDecimal integerPart = null;
            BigDecimal decimalPart = null;
            if(mnyStr.indexOf(".") < 0) {
                integerPart = new BigDecimal(mnyStr);
                decimalPart = BigDecimal.ZERO;
            } else {
                String[] mnyArr = mnyStr.split("\\.");
                integerPart = new BigDecimal(mnyArr[0]);
                if(mnyArr[1].length() > 4) {
                    decimalPart = new BigDecimal(mnyArr[1].substring(0,4));
                } else {
                    decimalPart = new BigDecimal(mnyArr[1]);
                }
            }

            //整数部分
            if(mny.signum() > 0) {
                int zeroCount = 0;
                int curNum = 0;
                String integerPartStr = integerPart.toString();
                List<String> numStr = Stream.iterate(0, n -> ++n).limit(integerPartStr.length())
                        .map(n -> "" + integerPartStr.charAt(n)).collect(Collectors.toList());
                int numLen = numStr.size();
                int p, q, m;
                for(int i = 0; i < numLen; i++) {
                    curNum = Integer.valueOf(numStr.get(i));
                    p = numLen - i - 1;
                    q = p / 4;
                    m = p % 4;

                    if(curNum == 0) {
                        zeroCount++;
                    } else {
                        if (zeroCount > 0) {
                            chineseStr.append(CN_NUMS[0]);
                        }
                        //归零
                        zeroCount = 0;
                        chineseStr.append(CN_NUMS[curNum]).append(CN_INT_RADICE[m]);
                    }
                    if (m == 0 && zeroCount < 4) {
                        chineseStr.append(CN_INT_UNITS[q]);
                    }
                }
                chineseStr.append(CN_INT_LAST);
            }

            //小数部分
            if(decimalPart.signum() > 0) {
                String decimalParttStr = decimalPart.toString();
                List<String> numStr = Stream.iterate(0, n -> ++n).limit(decimalParttStr.length())
                        .map(n -> "" + decimalParttStr.charAt(n)).collect(Collectors.toList());
                int numLen = numStr.size();
                int curNum = 0;
                for(int i=0; i<numLen; i++) {
                    curNum = Integer.valueOf(numStr.get(i));
                    if(i != 0) {
                        if(curNum != 0) {
                            chineseStr.append(CN_NUMS[curNum]).append(CN_DEC_UNINTS[i]);
                        }
                    } else {
                        chineseStr.append(CN_NUMS[curNum]);
                        if(curNum != 0) {
                            chineseStr.append(CN_DEC_UNINTS[i]);
                        }
                    }
                }
            }

            if(chineseStr.length() == 0) {
                chineseStr.append(CN_NUMS[0]).append(CN_INT_LAST).append(CN_INTEGER);
            } else if(decimalPart.compareTo(BigDecimal.ZERO) == 0) {
                chineseStr.append(CN_INTEGER);
            }
        }

        return chineseStr.toString();
    }
}
