package com.ejianc.business.production.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.CapitalEntity;
import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.service.IProductionTypeItemService;
import com.ejianc.business.production.vo.CapitalVO;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.mapper.OrgApplyMapper;
import com.ejianc.business.sddjsorg.mapper.OrgShareholderMapper;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.IOrgShareholderService;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.production.mapper.ProductionMapper;
import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.service.IProductionService;

import java.math.BigDecimal;
import java.util.*;

/**
 * 产权登记主表
 * 
 * @author generator
 * 
 */
@Service("productionService")
public class ProductionServiceImpl extends BaseServiceImpl<ProductionMapper, ProductionEntity> implements IProductionService{
    @Autowired
    private IOrgApplyService orgApplyService;
    @Autowired
    private OrgShareholderMapper orgShareholderMapper;
    @Autowired
    private IOrgShareholderService orgShareholderService;
    @Autowired
    private IProductionTypeItemService productionTypeItemService;
    @Autowired
    private ProductionMapper productionMapper;


    /**
     * 指派
     * @param param
     * @return
     */
    public CommonResponse<String> assignTask(Map<String,String> param) {
        try{
            String applyId=  param.get("applyId");
            String userId=  param.get("userId");
            String userName= param.get("userName");
            OrgApplyEntity orgApplyEntity =orgApplyService.getById(Long.valueOf(applyId));
            orgApplyEntity.setCurrentProcessorName(userName);
            orgApplyEntity.setCurrentProcessor(Long.valueOf(userId));
            orgApplyEntity.setPendingStartTime(new Date());
            orgApplyService.saveOrUpdate(orgApplyEntity);
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.success("指派失败");
        }

        return CommonResponse.success("指派成功");
    }

    /**
     * 根据申请id 和出资类型查询数据
     * @param applyId
     * @param contributionType
     * @return
     */
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdList(Long applyId, String contributionType) {
        QueryWrapper<OrgShareholderEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("pid", applyId);
        queryWrapper.eq("dr","0");
        if(StringUtils.isNotBlank(contributionType)){
            queryWrapper.eq("contribution_type",contributionType);
        }else{
            queryWrapper.ne("contribution_type","现金");
        }
        return orgShareholderMapper.selectList(queryWrapper);
    }

    /**
     * 查询产权登记类型子数据
     * @return
     */
    public List<ProductionTypeItemEntity> queryProductionTypeItemList() {
        return productionTypeItemService.list();
    }

    @Override
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdAllList(Long applyId) {
        QueryWrapper<OrgShareholderEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("pid", applyId);
        queryWrapper.eq("dr","0");

        return orgShareholderMapper.selectList(queryWrapper);
    }

    public List<CapitalVO> queryApplyShareholderByApplyIdSumCaptailName(Long applyId) {

        List<CapitalVO> resp = new ArrayList<CapitalVO>();
        QueryWrapper<OrgShareholderEntity> query = new QueryWrapper<>();
        query.select("  count(id) as  declaredNumberEnterprises,captail_type as  captailType");
        query.eq("pid", applyId);
        query.groupBy("captail_type");
        Map<String, Object> dataMap = orgShareholderService.getMap(query);
        if(dataMap != null){
            for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                CapitalVO vo = new CapitalVO();
                vo.setCaptailType((String) dataMap.get("captailType"));
                vo.setDeclaredNumberEnterprises((Long) (dataMap.get("declaredNumberEnterprises") != null?dataMap.get("declaredNumberEnterprises"):0));
                vo.setId(IdWorker.getId());
                resp.add(vo);
            }
        }

        return resp;

    }

    /**
     * 验证（收购企业） 收购手动输入的编号是否重复
     * @param unifiedSocialCreditCode
     * @return
     */
    public List<ProductionEntity> checkUnifiedSocialCreditCode(String unifiedSocialCreditCode) {
        QueryWrapper<ProductionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("unified_social_credit_code", unifiedSocialCreditCode);
        List<ProductionEntity> list =productionMapper.selectList(queryWrapper);
        return list;
    }

    @Override
    public List<ProductionEntity> queryProductionByApplyId(Long applyId) {
        QueryWrapper<ProductionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_apply_id",applyId);
        queryWrapper.notIn("bill_state","1,3");
        List<ProductionEntity> list =productionMapper.selectList(queryWrapper);
        return list;
    }

    /**
     *
     * @param applyId
     * @return
     *//*
    public ProductionEntity queryHistory(Long applyId) {
        OrgApplyEntity orgApplyEntity =orgApplyService.getById(applyId);
        QueryWrapper<ProductionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("org_id", orgApplyEntity.getInUseOrgId());
        List<ProductionEntity> list =productionMapper.selectList(queryWrapper);

        return null;
    }*/

}
