package com.ejianc.business.orgcenter.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.orgcenter.bean.DirectorEntity;
import com.ejianc.business.orgcenter.mapper.DirectorMapper;
import com.ejianc.business.orgcenter.service.IDirectorService;
import com.ejianc.business.orgcenter.vo.DirectorVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2021/9/28 16:24
 */
@Service(value = "directorService")
public class DirectorServiceImpl extends BaseServiceImpl<DirectorMapper, DirectorEntity> implements IDirectorService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private DirectorMapper directorMapper;

    @Autowired
    private IEmployeeApi employeeApi;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchDelByIds(List<Long> ids) {
        if(CollectionUtils.isNotEmpty(ids)) {
            directorMapper.batchDelByIds(ids);
        }
    }

    @Override
    public void syncEmployeeDetails() {
        QueryWrapper<DirectorEntity> query = new QueryWrapper();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("director_type", DirectorVO.EMP_INNER);

        List<DirectorEntity> directorList = directorMapper.selectList(query);
        Map<Long, DirectorEntity> directorEntityMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(directorList)) {
            List<Long> employeeIds = new ArrayList<>();
            for(DirectorEntity director : directorList) {
                directorEntityMap.put(director.getId(), director);
                employeeIds.add(director.getId());
            }
            CommonResponse<List<EmployeeVO>> employeeListResp = employeeApi.getByIds(employeeIds);
            if(!employeeListResp.isSuccess()) {
                logger.error("同步人员档案信息失败，获取人员档案失败: {}", employeeListResp.getMsg());
                throw new BusinessException("同步人员档案信息失败！");
            }
            List<EmployeeVO> empList = employeeListResp.getData();
            if(CollectionUtils.isNotEmpty(empList)) {
                DirectorEntity tmp = null;
                List<DirectorEntity> updateList = new ArrayList<>();
                for(EmployeeVO emp : empList) {
                    tmp = directorEntityMap.get(emp.getId());

                    tmp.setPostName(emp.getPostName());
                    tmp.setOrgName(emp.getOrgName());
                    tmp.setBillCode(emp.getCode());
                    tmp.setDirectorName(emp.getName());
                    directorList.remove(tmp);

                    updateList.add(tmp);
                }

                super.saveOrUpdateBatch(updateList);
                if(CollectionUtils.isNotEmpty(directorList)) {
                    directorMapper.batchDelByIds(directorList.stream().map(DirectorEntity::getId).collect(Collectors.toList()));
                }
            }
        }
    }
}
