package com.ejianc.business.sddjsorg.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.sddjsorg.bean.ShareholderDecisionEntity;
import com.ejianc.business.sddjsorg.bean.ShareholderDecisionFileEntity;
import com.ejianc.business.sddjsorg.service.IShareholderDecisionService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author CJ
 * @Description:
 * @date 2021/10/20 10:14
 */
@Service(value = "shareholderDecision")
public class ShareholderDecisionBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IShareholderDecisionService shareholderDecisionService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ShareholderDecisionEntity e = shareholderDecisionService.selectById(billId);
        logger.info("股东决策单据-【{}】执行提交前校验逻辑", JSONObject.toJSONString(e));
        if(CollectionUtils.isNotEmpty(e.getDocFiles())) {
            StringBuilder sp = new StringBuilder("提交失败！请上传");
            boolean checkFail = false;
            for(ShareholderDecisionFileEntity file : e.getDocFiles()) {
                if(file.getRequired() && "submit".equals(file.getCheckTime()) && StringUtils.isBlank(file.getFileIds())) {
                    checkFail = true;
                    sp.append("[").append(file.getFileSetName()).append("]");
                }
            }
            if(checkFail) {
                sp.append("的附件");
                return CommonResponse.error(sp.toString());
            }
        }

        return CommonResponse.success("股东决策审批前校验通过！");
    }

    /**
     * 提交审批
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ShareholderDecisionEntity e = shareholderDecisionService.selectById(billId);
        UserContext userContext = sessionManager.getUserContext();

        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        shareholderDecisionService.saveOrUpdate(e, false);

        return CommonResponse.success("股东决策审批回调处理成功！");
    }

    /**
     * 直审/审批通过
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

        if(state == 1) {
            ShareholderDecisionEntity e = shareholderDecisionService.selectById(billId);
            UserContext userContext = sessionManager.getUserContext();

            logger.info("股东决策单据-【{}】执行提交前校验逻辑", JSONObject.toJSONString(e));
            if(CollectionUtils.isNotEmpty(e.getDocFiles())) {
                StringBuilder sp = new StringBuilder("提交失败！请上传");
                boolean checkFail = false;
                for(ShareholderDecisionFileEntity file : e.getDocFiles()) {
                    if(file.getRequired() && "submit".equals(file.getCheckTime()) && StringUtils.isBlank(file.getFileIds())) {
                        checkFail = true;
                        sp.append("[").append(file.getFileSetName()).append("]");
                    }
                }
                if(checkFail) {
                    sp.append("的附件");
                    return CommonResponse.error(sp.toString());
                }
            }

            e.setCommitDate(new Date());
            e.setCommitUserCode(userContext.getUserCode());
            e.setCommitUserName(userContext.getUserName());
            shareholderDecisionService.saveOrUpdate(e, false);
        }

        return CommonResponse.success("股东决策审批回调处理成功！");
    }

    /**
     * 撤回回调处理
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return doBpmBack(billId, state, billTypeCode);
    }

    /**
     * 弃审回调处理
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return doBpmBack(billId, state, billTypeCode);
    }

    /**
     * 弃审、撤回回调处理
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    private CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        ShareholderDecisionEntity e = shareholderDecisionService.selectById(billId);
        logger.info("股东决策单据-【{}】执行撤回逻辑", JSONObject.toJSONString(e));

        //清空生效时间/提交人相关信息
        e.setEffectiveDate(null);
        e.setCommitDate(null);
        e.setCommitUserCode(null);
        e.setCommitUserName(null);
        shareholderDecisionService.saveOrUpdate(e, false);

        return CommonResponse.success("执行股东决策单据撤回逻辑成功! ");
    }

}
