/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.capital.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.capital.bean.CapitalRecRegistryEntity;
import com.ejianc.business.capital.bean.CapitalRecRegistrySubEntity;
import com.ejianc.business.capital.service.ICapitalRecRegistryService;
import com.ejianc.business.capital.util.MoneyUtils;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.bean.SddjsOrgEntity;
import com.ejianc.business.sddjsorg.service.ISddjsOrgService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="capitalRecRegistry")
public class CapitalRecRegistryBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICapitalRecRegistryService capitalRecRegistryService;
    @Autowired
    private ISddjsOrgService sddjsOrgService;

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        CapitalRecRegistryEntity e = (CapitalRecRegistryEntity)((Object)this.capitalRecRegistryService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.capitalRecRegistryService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u8d44\u672c\u91d1\u6536\u6b3e\u767b\u8bb0\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CapitalRecRegistryEntity e = (CapitalRecRegistryEntity)((Object)this.capitalRecRegistryService.selectById(billId));
        if (state == 1) {
            UserContext userContext = this.sessionManager.getUserContext();
            e.setCommitDate(new Date());
            e.setCommitUserCode(userContext.getUserCode());
            e.setCommitUserName(userContext.getUserName());
            this.capitalRecRegistryService.saveOrUpdate((Object)e, false);
        }
        if (CollectionUtils.isNotEmpty(e.getSubList())) {
            Map<Long, CapitalRecRegistrySubEntity> subMap = e.getSubList().stream().collect(Collectors.toMap(item -> item.getCaptailId(), item -> item));
            SddjsOrgEntity sddjsOrg = (SddjsOrgEntity)((Object)this.sddjsOrgService.selectById(e.getSddjsOrgId()));
            if (CollectionUtils.isNotEmpty(sddjsOrg.getOrgShareholderList())) {
                for (OrgShareholderEntity item2 : sddjsOrg.getOrgShareholderList()) {
                    if (null == subMap.get(item2.getId())) continue;
                    if (null != item2.getPaidCapital()) {
                        item2.setPaidCapital(item2.getPaidCapital().add(subMap.get(item2.getId()).getCurPayAmt()));
                    } else {
                        item2.setPaidCapital(subMap.get(item2.getId()).getPaidCapital());
                    }
                    item2.setPaidCapitalBig(MoneyUtils.getMnyUpCase(item2.getPaidCapital()));
                }
                this.sddjsOrgService.saveOrUpdate((Object)sddjsOrg, false);
            } else {
                return CommonResponse.error((String)("\u8d44\u672c\u91d1\u6536\u6b3e\u767b\u8bb0\u5ba1\u6279\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c\u7ec4\u7ec7\u673a\u6784[" + e.getSddjsOrgId() + "]\u7684\u80a1\u4e1c\u4fe1\u606f\u4e3a\u7a7a"));
            }
        }
        return CommonResponse.success((String)"\u8d44\u672c\u91d1\u6536\u6b3e\u767b\u8bb0\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        CapitalRecRegistryEntity e = (CapitalRecRegistryEntity)((Object)this.capitalRecRegistryService.selectById(billId));
        this.logger.info("\u8d44\u672c\u91d1\u6536\u6b3e\u767b\u8bb0\u5355\u636e-\u3010{}\u3011\u6267\u884c\u64a4\u56de\u903b\u8f91", (Object)JSONObject.toJSONString((Object)((Object)e)));
        this.logger.info("\u8d44\u672c\u91d1\u6536\u6b3e\u767b\u8bb0\u5355\u636e[billId-{}],[billTypeCode-{}]\u6267\u884c\u5f03\u5ba1\u524d\u6821\u9a8c\uff01", (Object)billId, (Object)billTypeCode);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"sddjs_org_id", (Object)e.getSddjsOrgId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.gt((Object)"create_time", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)e.getCreateTime()));
        List list = this.capitalRecRegistryService.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff01\u8be5\u516c\u53f8\u5df2\u7ecf\u5b58\u5728\u65b0\u7684[\u8d44\u672c\u91d1\u6536\u6b3e\u767b\u8bb0],\u4e0d\u5141\u8bb8\u53d6\u6d88\u5ba1\u6279\u3002");
        }
        e.setEffectiveDate(null);
        e.setCommitDate(null);
        e.setCommitUserCode(null);
        e.setCommitUserName(null);
        if (CollectionUtils.isNotEmpty(e.getSubList())) {
            Map<Long, CapitalRecRegistrySubEntity> subMap = e.getSubList().stream().collect(Collectors.toMap(item -> item.getCaptailId(), item -> item));
            SddjsOrgEntity sddjsOrg = (SddjsOrgEntity)((Object)this.sddjsOrgService.selectById(e.getSddjsOrgId()));
            if (CollectionUtils.isNotEmpty(sddjsOrg.getOrgShareholderList())) {
                for (OrgShareholderEntity item2 : sddjsOrg.getOrgShareholderList()) {
                    if (null == subMap.get(item2.getId())) continue;
                    item2.setPaidCapital(item2.getPaidCapital().subtract(subMap.get(item2.getId()).getCurPayAmt()));
                    item2.setPaidCapitalBig(MoneyUtils.getMnyUpCase(item2.getPaidCapital()));
                }
                this.sddjsOrgService.saveOrUpdate((Object)sddjsOrg, false);
            } else {
                return CommonResponse.error((String)("\u8d44\u672c\u91d1\u6536\u6b3e\u767b\u8bb0\u5ba1\u6279\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c\u7ec4\u7ec7\u673a\u6784[" + e.getSddjsOrgId() + "]\u7684\u80a1\u4e1c\u4fe1\u606f\u4e3a\u7a7a"));
            }
        }
        this.capitalRecRegistryService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u6267\u884c\u8d44\u672c\u91d1\u6536\u6b3e\u767b\u8bb0\u5355\u636e\u64a4\u56de\u903b\u8f91\u6210\u529f! ");
    }
}

