/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.InvestorsEntity;
import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.bean.ProductionOrgEntity;
import com.ejianc.business.production.mapper.ProductionOrgMapper;
import com.ejianc.business.production.service.IProductionOrgService;
import com.ejianc.business.production.service.IProductionService;
import com.ejianc.business.production.vo.HistoryVO;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.SddjsOrgEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.ISddjsOrgService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productionOrgService")
public class ProductionOrgServiceImpl
extends BaseServiceImpl<ProductionOrgMapper, ProductionOrgEntity>
implements IProductionOrgService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProductionOrgMapper productionOrgMapper;
    private static final String BILL_CODE = "sddjs-production-org";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOrgApplyService orgApplyService;
    @Autowired
    private ISddjsOrgService sddjsOrgService;

    @Override
    public ProductionOrgEntity getByProductionId(Long productionId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"production_id", (Object)productionId);
        wrapper.eq((Object)"dr", (Object)0);
        ProductionOrgEntity entity = new ProductionOrgEntity();
        List list = this.productionOrgMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            entity = (ProductionOrgEntity)((Object)list.get(0));
        }
        return entity;
    }

    @Override
    @Transactional
    public void saveOrUpdateOrgProduction(ProductionEntity entity) {
        if (entity.getApplyType().equals("set") || entity.getApplyType().equals("supplementary")) {
            this.savefound(entity);
        } else if (entity.getApplyType().equals("change")) {
            this.saveChange(entity);
        } else if (entity.getApplyType().equals("del")) {
            this.updateCancellation(entity);
        }
    }

    @Transactional
    public void savefound(ProductionEntity entity) {
        ProductionOrgEntity orgEntity = new ProductionOrgEntity();
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        orgEntity.setCode((String)billCode.getData());
        orgEntity = this.saveProductionOrg(entity, orgEntity);
        OrgApplyEntity orgApply = (OrgApplyEntity)((Object)this.orgApplyService.getById(entity.getSourceApplyId()));
        OrgVO orgVO = this.saveOrg(orgEntity, orgApply);
        orgEntity.setOrgId(orgVO.getId());
        SddjsOrgEntity sddjsOrgEntity = (SddjsOrgEntity)((Object)this.sddjsOrgService.getById(orgApply.getInUseOrgId()));
        sddjsOrgEntity.setOrgId(orgVO.getId());
        this.sddjsOrgService.saveOrUpdate((Object)sddjsOrgEntity);
        entity.setOrgId(orgVO.getId());
        this.productionService.saveOrUpdate((Object)entity);
        orgApply.setProductionState("registered");
        this.orgApplyService.saveOrUpdate((Object)orgApply);
        this.saveOrUpdate((Object)orgEntity);
    }

    @Transactional
    public ProductionOrgEntity saveProductionOrg(ProductionEntity entity, ProductionOrgEntity orgEntity) {
        orgEntity.setOutCapitalOrgName(entity.getOutCapitalOrgName());
        orgEntity.setRelationToOutOrg(entity.getReductionCapitalId());
        orgEntity.setRelationToOutOrgName(entity.getRelationToOutOrgName());
        orgEntity.setBeOwner(entity.getBeOwner());
        orgEntity.setMainCapitalOrgId(entity.getMainCapitalOrgId());
        orgEntity.setRelationToOutOrgName(entity.getMainCapitalOrgName());
        orgEntity.setRegisterCountryId(entity.getRegisterCountryId());
        orgEntity.setRegisterCountryName(entity.getRegisterCountryName());
        orgEntity.setRegisterIn(entity.getRegisterIn());
        orgEntity.setRegisterAddress(entity.getRegisterAddress());
        orgEntity.setRegisterDate(entity.getDateIncorporation());
        orgEntity.setCurrencyTypeId(entity.getCurrencyTypeId());
        orgEntity.setCurrencyTypeName(entity.getCurrencyTypeName());
        orgEntity.setRegisterCapital(entity.getRegisterCapital());
        orgEntity.setRegisterCapitalBig(entity.getRegisterCapitalBig());
        orgEntity.setOrgTypeId(entity.getOrgTypeId());
        orgEntity.setOrgTypeName(entity.getOrgTypeName());
        if (StringUtils.isNotEmpty((CharSequence)entity.getRegulatoryBodiesId())) {
            orgEntity.setRegulatoryBodiesId(Long.valueOf(entity.getRegulatoryBodiesId()));
        }
        orgEntity.setRegulatoryBodies(entity.getRegulatoryBodies());
        orgEntity.setOrgFormId(entity.getOrgFormId());
        orgEntity.setOrgFormName(entity.getOrgFormName());
        orgEntity.setMajorIndustriesId(entity.getMajorIndustriesId());
        orgEntity.setMajorIndustries(entity.getMajorIndustries());
        orgEntity.setProductLevel(entity.getProductLevel());
        orgEntity.setMangerLevel(entity.getMangerLevel());
        orgEntity.setBeListed(entity.getBeListed());
        orgEntity.setMergeTable(entity.getMergeTable());
        orgEntity.setBeClosed(entity.getBeClosed());
        orgEntity.setProductionId(entity.getId());
        orgEntity.setUseStatus(true);
        orgEntity.setName(entity.getName());
        orgEntity.setUnifiedSocialCreditCode(entity.getUnifiedSocialCreditCode());
        orgEntity.setInReacrd(entity.getInReacrd());
        if (StringUtils.isNotEmpty((CharSequence)entity.getOutCapitalOrg())) {
            orgEntity.setOutCapitalOrg(Long.valueOf(entity.getOutCapitalOrg()));
        }
        return orgEntity;
    }

    public void saveChange(ProductionEntity entity) {
        this.logger.info("\u8d70\u4e86\u53d8\u66f4~~~~~~~~~~~~~~~");
        OrgApplyEntity orgApply = (OrgApplyEntity)((Object)this.orgApplyService.getById(entity.getSourceApplyId()));
        SddjsOrgEntity sddjsOrgEntity = (SddjsOrgEntity)((Object)this.sddjsOrgService.getById(orgApply.getInUseOrgId()));
        ProductionOrgEntity orgEntity = this.getByOrgId(sddjsOrgEntity.getOrgId());
        orgEntity = this.saveProductionOrg(entity, orgEntity);
        OrgVO orgVO = this.saveOrg(orgEntity, orgApply);
        orgEntity.setOrgId(orgVO.getId());
        sddjsOrgEntity.setOrgId(orgVO.getId());
        this.sddjsOrgService.saveOrUpdate((Object)sddjsOrgEntity);
        List<ProductionEntity> productionList = this.productionService.queryProductionByApplyId(entity.getSourceApplyId());
        if (productionList.size() <= 1) {
            orgApply.setProductionState("registered");
            this.orgApplyService.saveOrUpdate((Object)orgApply);
        }
        entity.setOrgId(orgVO.getId());
        this.productionService.saveOrUpdate((Object)entity);
        this.addHistory(entity);
        this.saveOrUpdate((Object)orgEntity);
    }

    @Transactional
    public OrgVO saveOrg(ProductionOrgEntity orgEntity, OrgApplyEntity orgApply) {
        CommonResponse responseOrgVo = this.orgApi.getOneById(orgEntity.getOrgId());
        OrgVO projectDepartment = new OrgVO();
        if (responseOrgVo.getData() != null) {
            projectDepartment = (OrgVO)responseOrgVo.getData();
        } else {
            projectDepartment.setId(Long.valueOf(IdWorker.getId()));
        }
        projectDepartment.setParentId(orgApply.getDirectSuperiorOrgId());
        projectDepartment.setTenantId(InvocationInfoProxy.getTenantid());
        projectDepartment.setIsParent(Boolean.valueOf(false));
        projectDepartment.setName(orgEntity.getName());
        projectDepartment.setShortName(orgEntity.getName());
        projectDepartment.setState(Integer.valueOf(1));
        projectDepartment.setOrgType(Integer.valueOf(2));
        CommonResponse commonResponse = this.orgApi.saveOrgInfo(projectDepartment);
        if (commonResponse.getCode() != 0) {
            throw new BusinessException("\u63a8\u9001\u7ec4\u7ec7\u7ed3\u6784\u5f02\u5e38");
        }
        return (OrgVO)commonResponse.getData();
    }

    public HistoryVO updateHistory(String name, String after, String before) {
        HistoryVO vo = new HistoryVO(name, before, after);
        return vo;
    }

    public void updateCancellation(ProductionEntity entity) {
        List<ProductionEntity> productionList;
        OrgApplyEntity orgApply = (OrgApplyEntity)((Object)this.orgApplyService.getById(entity.getSourceApplyId()));
        SddjsOrgEntity sddjsOrgEntity = (SddjsOrgEntity)((Object)this.sddjsOrgService.getById(orgApply.getInUseOrgId()));
        CommonResponse responseOrgVo = this.orgApi.getOneById(sddjsOrgEntity.getOrgId());
        OrgVO projectDepartment = new OrgVO();
        if (responseOrgVo.getData() != null) {
            projectDepartment = (OrgVO)responseOrgVo.getData();
            projectDepartment.setState(Integer.valueOf(0));
            this.orgApi.saveOrgInfo(projectDepartment);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"org_id", (Object)sddjsOrgEntity.getOrgId());
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ProductionOrgEntity orgEntity = (ProductionOrgEntity)((Object)list.get(0));
            orgEntity.setUseStatus(false);
            this.saveOrUpdate((Object)orgEntity);
        }
        if ((productionList = this.productionService.queryProductionByApplyId(entity.getSourceApplyId())).size() <= 1) {
            orgApply.setProductionState("registered");
            this.orgApplyService.saveOrUpdate((Object)orgApply);
        }
        entity.setOrgId(sddjsOrgEntity.getOrgId());
        this.productionService.saveOrUpdate((Object)entity);
    }

    @Transactional
    public void addHistory(ProductionEntity entity) {
        ArrayList<HistoryVO> historyVOList = new ArrayList<HistoryVO>();
        ProductionEntity productionEntity = (ProductionEntity)((Object)this.productionService.selectById(entity.getId()));
        OrgApplyEntity orgApply = (OrgApplyEntity)((Object)this.orgApplyService.getById(entity.getSourceApplyId()));
        SddjsOrgEntity sddjsOrgEntity = (SddjsOrgEntity)((Object)this.sddjsOrgService.getById(orgApply.getInUseOrgId()));
        ProductionOrgEntity orgEntity = this.getByOrgId(sddjsOrgEntity.getOrgId());
        this.logger.info("orgEntity=============", (Object)orgEntity);
        historyVOList.add(this.updateHistory("\u4f01\u4e1a\u540d\u79f0", orgEntity.getName(), entity.getName()));
        historyVOList.add(this.updateHistory("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801", orgEntity.getUnifiedSocialCreditCode(), entity.getUnifiedSocialCreditCode()));
        historyVOList.add(this.updateHistory("\u662f\u5426\u5728\u96c6\u56e2\u5907\u6848", orgEntity.getInReacrd() != null ? (orgEntity.getInReacrd().booleanValue() ? "\u5907\u6848" : "\u672a\u5907\u6848") : "", entity.getInReacrd() != null ? (entity.getInReacrd().booleanValue() ? "\u5907\u6848" : "\u672a\u5907\u6848") : ""));
        historyVOList.add(this.updateHistory("\u56fd\u5bb6\u51fa\u8d44\u4f01\u4e1a\u540d\u79f0", orgEntity.getOutCapitalOrgName() != null ? orgEntity.getOutCapitalOrgName() : "", entity.getOutCapitalOrgName() != null ? entity.getOutCapitalOrgName() : ""));
        historyVOList.add(this.updateHistory("\u4e0e\u56fd\u5bb6\u51fa\u8d44\u4f01\u4e1a\u7684\u5173\u7cfb\u540d\u79f0", orgEntity.getRelationToOutOrgName() != null ? orgEntity.getRelationToOutOrgName() : "", entity.getRelationToOutOrgName() != null ? entity.getRelationToOutOrgName() : ""));
        historyVOList.add(this.updateHistory("\u662f\u5426\u56fd\u5bb6\u51fa\u8d44\u4f01\u4e1a\u4e1a\u4e3b", orgEntity.getBeOwner() == true ? "\u662f" : "\u5426", entity.getBeOwner() == true ? "\u662f" : "\u5426"));
        historyVOList.add(this.updateHistory("\u4e3b\u8981\u51fa\u8d44\u4eba\u540d\u79f0", orgEntity.getMainCapitalOrgName() != null ? orgEntity.getMainCapitalOrgName() : "", entity.getMainCapitalOrgName() != null ? entity.getMainCapitalOrgName() : ""));
        historyVOList.add(this.updateHistory("\u6ce8\u518c\u56fd\u5bb6\u540d\u79f0", orgEntity.getRegisterCountryName() != null ? orgEntity.getRegisterCountryName() : "", entity.getRegisterCountryName() != null ? entity.getRegisterCountryName() : ""));
        historyVOList.add(this.updateHistory("\u6ce8\u518c\u5730\u5883", orgEntity.getRegisterIn() != null ? orgEntity.getRegisterIn() : "", entity.getRegisterIn() != null ? entity.getRegisterIn() : ""));
        historyVOList.add(this.updateHistory("\u6ce8\u518c\u5730", orgEntity.getRegisterAddress() != null ? orgEntity.getRegisterAddress() : "", entity.getRegisterAddress() != null ? entity.getRegisterAddress() : ""));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        historyVOList.add(this.updateHistory("\u6ce8\u518c\u65e5\u671f", sdf.format(orgEntity.getRegisterDate() != null ? orgEntity.getRegisterDate() : new Date()), sdf.format(entity.getDateIncorporation() != null ? entity.getDateIncorporation() : new Date())));
        historyVOList.add(this.updateHistory("\u6ce8\u518c\u8d44\u672c\u5e01\u79cd\u540d\u79f0", orgEntity.getCurrencyTypeName() != null ? orgEntity.getCurrencyTypeName() : "", entity.getCurrencyTypeName() != null ? entity.getCurrencyTypeName() : ""));
        historyVOList.add(this.updateHistory("\u4f01\u4e1a\u7c7b\u522b\u540d\u79f0", orgEntity.getOrgTypeName() != null ? orgEntity.getOrgTypeName() : "", entity.getOrgTypeName() != null ? entity.getOrgTypeName() : ""));
        historyVOList.add(this.updateHistory("\u6ce8\u518c\u8d44\u672c", orgEntity.getCurrencyTypeName() != null ? orgEntity.getCurrencyTypeName() : "", entity.getCurrencyTypeName() != null ? entity.getCurrencyTypeName() : ""));
        historyVOList.add(this.updateHistory("\u6ce8\u518c\u8d44\u672c\u5927\u5199", orgEntity.getRegisterCapitalBig() != null ? orgEntity.getRegisterCapitalBig() : "", entity.getRegisterCapitalBig() != null ? entity.getRegisterCapitalBig() : ""));
        historyVOList.add(this.updateHistory("\u56fd\u8d44\u76d1\u7ba1\u673a\u6784", orgEntity.getRegulatoryBodies() != null ? orgEntity.getRegulatoryBodies() : "", entity.getRegulatoryBodies() != null ? entity.getRegulatoryBodies() : ""));
        historyVOList.add(this.updateHistory("\u7ec4\u7ec7\u5f62\u5f0f", orgEntity.getOrgFormName() != null ? orgEntity.getOrgFormName() : "", entity.getOrgFormName() != null ? entity.getOrgFormName() : ""));
        historyVOList.add(this.updateHistory("\u4e3b\u8981\u884c\u4e1a", orgEntity.getMajorIndustries() != null ? orgEntity.getMajorIndustries() : "", entity.getMajorIndustries() != null ? entity.getMajorIndustries() : ""));
        historyVOList.add(this.updateHistory("\u4f01\u4e1a\u4ea7\u6743\u7ea7\u6b21", orgEntity.getProductLevel() != null ? orgEntity.getProductLevel() : "", entity.getProductLevel() != null ? entity.getProductLevel() : ""));
        historyVOList.add(this.updateHistory("\u4f01\u4e1a\u7ba1\u7406\u7ea7\u6b21", orgEntity.getMangerLevel() != null ? orgEntity.getMangerLevel() : "", entity.getMangerLevel() != null ? entity.getMangerLevel() : ""));
        historyVOList.add(this.updateHistory("\u662f\u5426\u4e0a\u5e02\u516c\u53f8", orgEntity.getBeListed() != null ? (orgEntity.getBeListed().booleanValue() ? "\u662f" : "\u5426") : "", entity.getBeListed() != null ? (entity.getBeListed().booleanValue() ? "\u662f" : "\u5426") : ""));
        historyVOList.add(this.updateHistory("\u662f\u5426\u5e76\u8868", orgEntity.getMergeTable() != null ? (orgEntity.getMergeTable().booleanValue() ? "\u662f" : "\u5426") : "", entity.getMergeTable() != null ? (entity.getMergeTable().booleanValue() ? "\u662f" : "\u5426") : ""));
        historyVOList.add(this.updateHistory("\u662f\u5426\u5b58\u5728\u4f11\u7720/\u505c\u4e1a/\u6b47\u4e1a\u7b49\u60c5\u51b5", orgEntity.getBeClosed() != null ? (orgEntity.getBeClosed().booleanValue() ? "\u662f" : "\u5426") : "", entity.getBeClosed() != null ? (entity.getBeClosed().booleanValue() ? "\u662f" : "\u5426") : ""));
        JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString(historyVOList));
        productionEntity.setHistoryRecord(JSONArray.toJSONString((Object)jsonArray));
        List<InvestorsEntity> investorsBeforeList = productionEntity.getInvestorsEntities();
        List<InvestorsEntity> investorsAfterList = entity.getInvestorsEntities();
        productionEntity.setInvestorsBefore(JSON.toJSONString(investorsBeforeList));
        productionEntity.setInvestorsAfter(JSON.toJSONString(investorsAfterList));
        this.productionService.updateById((Object)productionEntity);
    }

    public ProductionOrgEntity getByOrgId(Long orgId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"org_id", (Object)orgId);
        ProductionOrgEntity entity = new ProductionOrgEntity();
        List list = this.productionOrgMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            entity = (ProductionOrgEntity)((Object)list.get(0));
        }
        return entity;
    }
}

