package com.ejianc.business.sddjsorg.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 组织机构实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sddjsorg_org")
public class SddjsOrgEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="name")
    private String name; // 公司名称
    @TableField(value="code")
    private String code; // 公司编号
    @TableField(value="name_short_cn")
    private String nameShortCn; // 公司名称中文缩写
    @TableField(value="name_short_en")
    private String nameShortEn; // 公司名称英文缩写
    @TableField(value="org_nature_id")
    private Long orgNatureId; // 公司注册性质id
    @TableField(value="org_nature_name")
    private String orgNatureName; // 公司注册性质
    @TableField(value="direct_superior_id")
    private Long directSuperiorId; // 直接上级单位id
    @TableField(value="direct_superior")
    private String directSuperior; // 直接上级单位
    @TableField(value="direct_superior_org_id")
    private Long directSuperiorOrgId; // 直接上级单位平台组织id
    @TableField(value="subject_corporate_management_responsibility")
    private String subjectCorporateManagementResponsibility; // 公司管理责任主体
    @TableField(value="subject_corporate_management_responsibility_name")
    private String subjectCorporateManagementResponsibilityName; // 公司管理责任主体
    @TableField(value="register_country_id")
    private Long registerCountryId; // 注册国家地区id
    @TableField(value="register_country_name")
    private String registerCountryName; // 注册国家地区名称
    @TableField(value="register_area_v")
    private String registerAreaV; // 注册所在地区value
    @TableField(value="register_area_name")
    private String registerAreaName; // 注册所在地区name
    @TableField(value="register_address")
    private String registerAddress; // 注册地详细地址
    @TableField(value="register_in")
    private String registerIn; // 注册地境内/境外
    @TableField(value="report_merge")
    private Integer reportMerge; // 报表合并
    @TableField(value="whether_report_to_group")
    private Integer whetherReportToGroup; // 是否上报集团批复
    @TableField(value="apply_reason")
    private String applyReason; // 申请原因、注销原因
    @TableField(value="business_scope")
    private String businessScope; // 营业范围
    @TableField(value="register_capital")
    private BigDecimal registerCapital; // 注册资本
    @TableField(value="currency_type_id")
    private Long currencyTypeId; // 注册资本币种id
    @TableField(value="currency_type_name")
    private String currencyTypeName; // 注册资本币种名称
    @TableField(value="control_status")
    private Long controlStatus; // 控制状态id
    @TableField(value="control_status_name")
    private String controlStatusName; // 控制状态
    @TableField(value="equity_ratio")
    private BigDecimal equityRatio; // 股权比例
    @TableField(value="legal_representative")
    private Long legalRepresentative; // 法定人代表
    @TableField(value="legal_representative_name")
    private String legalRepresentativeName; // 法定人代表
    @TableField(value="director")
    private Long director; // 董事
    @TableField(value="director_name")
    private String directorName; // 董事
    @TableField(value="supervisor")
    private Long supervisor; // 监事
    @TableField(value="supervisor_name")
    private String supervisorName; // 监事
    @TableField(value="general_manager")
    private Long generalManager; // 总经理
    @TableField(value="general_manager_name")
    private String generalManagerName; // 总经理
    @TableField(value="acting_holder")
    private Long actingHolder; // 代持方
    @TableField(value="acting_holder_name")
    private String actingHolderName; // 代持方
    @TableField(value="held_by_employees")
    private BigDecimal heldByEmployees; // 职工持有(%)
    @TableField(value="held_by_subsidiary")
    private BigDecimal heldBySubsidiary; // 分子公司持有(%)
    @TableField(value="held_by_local")
    private BigDecimal heldByLocal; // 当地居民或公司持有
    @TableField(value="date_incorporation")
    private Date dateIncorporation; // 成立日期
    @TableField(value="unified_social_credit_code")
    private String unifiedSocialCreditCode; // 统一社会信用代码
    @TableField(value="taxpayer_number")
    private String taxpayerNumber; // 纳税人识别号
    @TableField(value="bank_account_number")
    private String bankAccountNumber; // 银行基本账号
    @TableField(value="use_state")
    private String useState; // ：use：在用，nouse：注销

    @TableField(value="org_id")
    private Long orgId; // 平台组织id
    
    @TableField(value="legal_flag")
    private Integer legalFlag; // 是否法人单位

    @TableField(exist=false)
    @SubEntity(serviceName="orgShareholderService", pidName="pid")
    private List<OrgShareholderEntity> orgShareholderList = new ArrayList<>(); // 组织申请单-上传档案项
    
    /**
     * 公司名称
     */
    public String getName() {
        return name;
    }

    /**
     * 公司名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 公司编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 公司编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 公司名称中文缩写
     */
    public String getNameShortCn() {
        return nameShortCn;
    }

    /**
     * 公司名称中文缩写
     */
    public void setNameShortCn(String nameShortCn) {
        this.nameShortCn = nameShortCn;
    }
    /**
     * 公司名称英文缩写
     */
    public String getNameShortEn() {
        return nameShortEn;
    }

    /**
     * 公司名称英文缩写
     */
    public void setNameShortEn(String nameShortEn) {
        this.nameShortEn = nameShortEn;
    }
    /**
     * 公司注册性质id
     */
    public Long getOrgNatureId() {
        return orgNatureId;
    }

    /**
     * 公司注册性质id
     */
    public void setOrgNatureId(Long orgNatureId) {
        this.orgNatureId = orgNatureId;
    }
    /**
     * 公司注册性质
     */
    public String getOrgNatureName() {
        return orgNatureName;
    }

    /**
     * 公司注册性质
     */
    public void setOrgNatureName(String orgNatureName) {
        this.orgNatureName = orgNatureName;
    }
    /**
     * 直接上级单位id
     */
    public Long getDirectSuperiorId() {
        return directSuperiorId;
    }

    /**
     * 直接上级单位id
     */
    public void setDirectSuperiorId(Long directSuperiorId) {
        this.directSuperiorId = directSuperiorId;
    }
    /**
     * 直接上级单位
     */
    public String getDirectSuperior() {
        return directSuperior;
    }

    /**
     * 直接上级单位
     */
    public void setDirectSuperior(String directSuperior) {
        this.directSuperior = directSuperior;
    }
    /**
     * 公司管理责任主体
     */
    public String getSubjectCorporateManagementResponsibility() {
        return subjectCorporateManagementResponsibility;
    }

    /**
     * 公司管理责任主体
     */
    public void setSubjectCorporateManagementResponsibility(String subjectCorporateManagementResponsibility) {
        this.subjectCorporateManagementResponsibility = subjectCorporateManagementResponsibility;
    }
    /**
     * 注册国家地区id
     */
    public Long getRegisterCountryId() {
        return registerCountryId;
    }

    /**
     * 注册国家地区id
     */
    public void setRegisterCountryId(Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }
    /**
     * 注册国家地区名称
     */
    public String getRegisterCountryName() {
        return registerCountryName;
    }

    /**
     * 注册国家地区名称
     */
    public void setRegisterCountryName(String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }
    /**
     * 注册所在地区value
     */
    public String getRegisterAreaV() {
        return registerAreaV;
    }

    /**
     * 注册所在地区value
     */
    public void setRegisterAreaV(String registerAreaV) {
        this.registerAreaV = registerAreaV;
    }
    /**
     * 注册所在地区name
     */
    public String getRegisterAreaName() {
        return registerAreaName;
    }

    /**
     * 注册所在地区name
     */
    public void setRegisterAreaName(String registerAreaName) {
        this.registerAreaName = registerAreaName;
    }
    /**
     * 注册地详细地址
     */
    public String getRegisterAddress() {
        return registerAddress;
    }

    /**
     * 注册地详细地址
     */
    public void setRegisterAddress(String registerAddress) {
        this.registerAddress = registerAddress;
    }
    /**
     * 注册地境内/境外
     */
    public String getRegisterIn() {
        return registerIn;
    }

    /**
     * 注册地境内/境外
     */
    public void setRegisterIn(String registerIn) {
        this.registerIn = registerIn;
    }
    /**
     * 报表合并
     */
    public Integer getReportMerge() {
        return reportMerge;
    }

    /**
     * 报表合并
     */
    public void setReportMerge(Integer reportMerge) {
        this.reportMerge = reportMerge;
    }
    /**
     * 是否上报集团批复
     */
    public Integer getWhetherReportToGroup() {
        return whetherReportToGroup;
    }

    /**
     * 是否上报集团批复
     */
    public void setWhetherReportToGroup(Integer whetherReportToGroup) {
        this.whetherReportToGroup = whetherReportToGroup;
    }
    /**
     * 申请原因、注销原因
     */
    public String getApplyReason() {
        return applyReason;
    }

    /**
     * 申请原因、注销原因
     */
    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }
    /**
     * 营业范围
     */
    public String getBusinessScope() {
        return businessScope;
    }

    /**
     * 营业范围
     */
    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }
    /**
     * 注册资本
     */
    public BigDecimal getRegisterCapital() {
        return registerCapital;
    }

    /**
     * 注册资本
     */
    public void setRegisterCapital(BigDecimal registerCapital) {
        this.registerCapital = registerCapital;
    }
    /**
     * 注册资本币种id
     */
    public Long getCurrencyTypeId() {
        return currencyTypeId;
    }

    /**
     * 注册资本币种id
     */
    public void setCurrencyTypeId(Long currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }
    /**
     * 注册资本币种名称
     */
    public String getCurrencyTypeName() {
        return currencyTypeName;
    }

    /**
     * 注册资本币种名称
     */
    public void setCurrencyTypeName(String currencyTypeName) {
        this.currencyTypeName = currencyTypeName;
    }
    /**
     * 控制状态id
     */
    public Long getControlStatus() {
        return controlStatus;
    }

    /**
     * 控制状态id
     */
    public void setControlStatus(Long controlStatus) {
        this.controlStatus = controlStatus;
    }
    /**
     * 控制状态
     */
    public String getControlStatusName() {
        return controlStatusName;
    }

    /**
     * 控制状态
     */
    public void setControlStatusName(String controlStatusName) {
        this.controlStatusName = controlStatusName;
    }
    /**
     * 股权比例
     */
    public BigDecimal getEquityRatio() {
        return equityRatio;
    }

    /**
     * 股权比例
     */
    public void setEquityRatio(BigDecimal equityRatio) {
        this.equityRatio = equityRatio;
    }
    /**
     * 法定人代表
     */
    public Long getLegalRepresentative() {
        return legalRepresentative;
    }

    /**
     * 法定人代表
     */
    public void setLegalRepresentative(Long legalRepresentative) {
        this.legalRepresentative = legalRepresentative;
    }
    /**
     * 法定人代表
     */
    public String getLegalRepresentativeName() {
        return legalRepresentativeName;
    }

    /**
     * 法定人代表
     */
    public void setLegalRepresentativeName(String legalRepresentativeName) {
        this.legalRepresentativeName = legalRepresentativeName;
    }
    /**
     * 董事
     */
    public Long getDirector() {
        return director;
    }

    /**
     * 董事
     */
    public void setDirector(Long director) {
        this.director = director;
    }
    /**
     * 董事
     */
    public String getDirectorName() {
        return directorName;
    }

    /**
     * 董事
     */
    public void setDirectorName(String directorName) {
        this.directorName = directorName;
    }
    /**
     * 监事
     */
    public Long getSupervisor() {
        return supervisor;
    }

    /**
     * 监事
     */
    public void setSupervisor(Long supervisor) {
        this.supervisor = supervisor;
    }
    /**
     * 监事
     */
    public String getSupervisorName() {
        return supervisorName;
    }

    /**
     * 监事
     */
    public void setSupervisorName(String supervisorName) {
        this.supervisorName = supervisorName;
    }
    /**
     * 总经理
     */
    public Long getGeneralManager() {
        return generalManager;
    }

    /**
     * 总经理
     */
    public void setGeneralManager(Long generalManager) {
        this.generalManager = generalManager;
    }
    /**
     * 总经理
     */
    public String getGeneralManagerName() {
        return generalManagerName;
    }

    /**
     * 总经理
     */
    public void setGeneralManagerName(String generalManagerName) {
        this.generalManagerName = generalManagerName;
    }
    /**
     * 代持方
     */
    public Long getActingHolder() {
        return actingHolder;
    }

    /**
     * 代持方
     */
    public void setActingHolder(Long actingHolder) {
        this.actingHolder = actingHolder;
    }
    /**
     * 职工持有(%)
     */
    public BigDecimal getHeldByEmployees() {
        return heldByEmployees;
    }

    /**
     * 职工持有(%)
     */
    public void setHeldByEmployees(BigDecimal heldByEmployees) {
        this.heldByEmployees = heldByEmployees;
    }
    /**
     * 分子公司持有(%)
     */
    public BigDecimal getHeldBySubsidiary() {
        return heldBySubsidiary;
    }

    /**
     * 分子公司持有(%)
     */
    public void setHeldBySubsidiary(BigDecimal heldBySubsidiary) {
        this.heldBySubsidiary = heldBySubsidiary;
    }
    /**
     * 当地居民或公司持有
     */
    public BigDecimal getHeldByLocal() {
        return heldByLocal;
    }

    /**
     * 当地居民或公司持有
     */
    public void setHeldByLocal(BigDecimal heldByLocal) {
        this.heldByLocal = heldByLocal;
    }
    /**
     * 成立日期
     */
    public Date getDateIncorporation() {
        return dateIncorporation;
    }

    /**
     * 成立日期
     */
    public void setDateIncorporation(Date dateIncorporation) {
        this.dateIncorporation = dateIncorporation;
    }
    /**
     * 统一社会信用代码
     */
    public String getUnifiedSocialCreditCode() {
        return unifiedSocialCreditCode;
    }

    /**
     * 统一社会信用代码
     */
    public void setUnifiedSocialCreditCode(String unifiedSocialCreditCode) {
        this.unifiedSocialCreditCode = unifiedSocialCreditCode;
    }
    /**
     * 纳税人识别号
     */
    public String getTaxpayerNumber() {
        return taxpayerNumber;
    }

    /**
     * 纳税人识别号
     */
    public void setTaxpayerNumber(String taxpayerNumber) {
        this.taxpayerNumber = taxpayerNumber;
    }
    /**
     * 银行基本账号
     */
    public String getBankAccountNumber() {
        return bankAccountNumber;
    }

    /**
     * 银行基本账号
     */
    public void setBankAccountNumber(String bankAccountNumber) {
        this.bankAccountNumber = bankAccountNumber;
    }
    /**
     * 使用状态：use：在用，nouse：注销
     */
    public String getUseState() {
        return useState;
    }

    /**
     * 使用状态：use：在用，nouse：注销
     */
    public void setUseState(String useState) {
        this.useState = useState;
    }

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Integer getLegalFlag() {
		return legalFlag;
	}

	public void setLegalFlag(Integer legalFlag) {
		this.legalFlag = legalFlag;
	}

	public List<OrgShareholderEntity> getOrgShareholderList() {
		return orgShareholderList;
	}

	public void setOrgShareholderList(List<OrgShareholderEntity> orgShareholderList) {
		this.orgShareholderList = orgShareholderList;
	}

	public Long getDirectSuperiorOrgId() {
		return directSuperiorOrgId;
	}

	public void setDirectSuperiorOrgId(Long directSuperiorOrgId) {
		this.directSuperiorOrgId = directSuperiorOrgId;
	}

	public String getSubjectCorporateManagementResponsibilityName() {
		return subjectCorporateManagementResponsibilityName;
	}

	public void setSubjectCorporateManagementResponsibilityName(String subjectCorporateManagementResponsibilityName) {
		this.subjectCorporateManagementResponsibilityName = subjectCorporateManagementResponsibilityName;
	}

	public String getActingHolderName() {
		return actingHolderName;
	}

	public void setActingHolderName(String actingHolderName) {
		this.actingHolderName = actingHolderName;
	}
    
}
