package com.ejianc.business.capital.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 资本金收款登记
 *
 * @author CJ
 * @Description: 资本金收款登记
 * @date 2021/10/19 10:14
 */
@TableName(value = "ejc_sddjsorg_capital_rec_registry")
public class CapitalRecRegistryEntity extends BaseEntity {

    private static final long serialVersionUID = -1453915697318323938L;
    /**
     * 登记人所属组织Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 登记人所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 登记组织机构Id
     */
    @TableField(value = "sddjs_org_id")
    private Long sddjsOrgId;

    /**
     * 登记组织机构名称
     */
    @TableField(value = "sddjs_org_name")
    private String sddjsOrgName;

    /**
     * 出资方名称，多个逗号分隔
     */
    @TableField(value="captail_names")
    private String captailNames;

    /**
     * 注册资本
     */
    @TableField(value="register_capital")
    private BigDecimal registerCapital;

    /**
     * 注册资本币种id
     */
    @TableField(value="currency_type_id")
    private Long currencyTypeId;

    /**
     * 注册资本币种名称
     */
    @TableField(value="currency_type_name")
    private String currencyTypeName;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    @TableField(exist=false)
    @SubEntity(serviceName="capitalRecRegistrySubService", pidName="capitalRecRegistryId")
    List<CapitalRecRegistrySubEntity> subList;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 提交日期
     */
    @TableField(value = "commit_date")
    private Date commitDate;

    /**
     * 提交人名称
     */
    @TableField(value = "commit_user_name")
    private String commitUserName;

    /**
     * 提交人账号
     */
    @TableField(value = "commit_user_code")
    private String commitUserCode;

    /**
     * 生效日期
     */
    @TableField(value = "effective_date")
    private Date effectiveDate;

    /**
     * 创建人名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 修改人名称
     */
    @TableField(value = "modify_user_name")
    private String modifyUserName;

    /**
     * 单据编码
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 本次总共收款金额
     */
    @TableField(value = "cur_total_rec_amt")
    private BigDecimal curTotalRecAmt;

    public BigDecimal getCurTotalRecAmt() {
        return curTotalRecAmt;
    }

    public void setCurTotalRecAmt(BigDecimal curTotalRecAmt) {
        this.curTotalRecAmt = curTotalRecAmt;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getSddjsOrgId() {
        return sddjsOrgId;
    }

    public void setSddjsOrgId(Long sddjsOrgId) {
        this.sddjsOrgId = sddjsOrgId;
    }

    public String getSddjsOrgName() {
        return sddjsOrgName;
    }

    public void setSddjsOrgName(String sddjsOrgName) {
        this.sddjsOrgName = sddjsOrgName;
    }

    public String getCaptailNames() {
        return captailNames;
    }

    public void setCaptailNames(String captailNames) {
        this.captailNames = captailNames;
    }

    public BigDecimal getRegisterCapital() {
        return registerCapital;
    }

    public void setRegisterCapital(BigDecimal registerCapital) {
        this.registerCapital = registerCapital;
    }

    public Long getCurrencyTypeId() {
        return currencyTypeId;
    }

    public void setCurrencyTypeId(Long currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }

    public String getCurrencyTypeName() {
        return currencyTypeName;
    }

    public void setCurrencyTypeName(String currencyTypeName) {
        this.currencyTypeName = currencyTypeName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<CapitalRecRegistrySubEntity> getSubList() {
        return subList;
    }

    public void setSubList(List<CapitalRecRegistrySubEntity> subList) {
        this.subList = subList;
    }
}
